/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson;

import com.google.gson.GsonBuilder;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionSerializer;
import com.mapbox.services.commons.models.Position;

public class Point
implements Geometry<Position> {
    private final String type = "Point";
    private Position coordinates;

    private Point(Position coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public String getType() {
        return "Point";
    }

    @Override
    public Position getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void setCoordinates(Position coordinates) {
        this.coordinates = coordinates;
    }

    public static Point fromCoordinates(Position coordinates) {
        return new Point(coordinates);
    }

    public static Point fromCoordinates(double[] coordinates) {
        return Point.fromCoordinates(Position.fromCoordinates((double[])coordinates));
    }

    public static Point fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        return (Point)gson.create().fromJson(json, Point.class);
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionSerializer());
        return gson.create().toJson((Object)this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Point point = (Point)object;
        return this.coordinates.equals((Object)point.coordinates);
    }

    public int hashCode() {
        int result = "Point".hashCode();
        result = 31 * result + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Point{type='Point', coordinates=" + this.coordinates + '}';
    }
}

