/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.util.Log;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.android.telemetry.AppStateUtils;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.location.LocationCollectionClient;
import com.mapbox.android.telemetry.location.LocationMapper;
import java.util.List;

public class LocationUpdatesBroadcastReceiver
extends BroadcastReceiver {
    private static final String TAG = "LocationUpdateReceiver";
    static final String ACTION_LOCATION_UPDATED = "com.mapbox.android.telemetry.location.locationupdatespendingintent.action.LOCATION_UPDATED";

    public void onReceive(Context context, Intent intent) {
        try {
            if (intent == null) {
                Log.w((String)TAG, (String)"intent == null");
                return;
            }
            String action = intent.getAction();
            if (!ACTION_LOCATION_UPDATED.equals(action)) {
                return;
            }
            LocationEngineResult result = LocationEngineResult.extractResult((Intent)intent);
            if (result == null) {
                Log.w((String)TAG, (String)"LocationEngineResult == null");
                return;
            }
            LocationCollectionClient collectionClient = LocationCollectionClient.getInstance();
            MapboxTelemetry telemetry = collectionClient.getTelemetry();
            String sessionId = collectionClient.getSessionId();
            List locations = result.getLocations();
            for (Location location : locations) {
                if (LocationUpdatesBroadcastReceiver.isThereAnyNaN(location) || LocationUpdatesBroadcastReceiver.isThereAnyInfinite(location)) continue;
                String appState = AppStateUtils.getAppState(context).toString();
                telemetry.push(LocationMapper.create(location, appState, sessionId));
            }
        }
        catch (Throwable throwable) {
            Log.e((String)TAG, (String)throwable.toString());
        }
    }

    private static boolean isThereAnyNaN(Location location) {
        return Double.isNaN(location.getLatitude()) || Double.isNaN(location.getLongitude()) || Double.isNaN(location.getAltitude()) || Float.isNaN(location.getAccuracy());
    }

    private static boolean isThereAnyInfinite(Location location) {
        return Double.isInfinite(location.getLatitude()) || Double.isInfinite(location.getLongitude()) || Double.isInfinite(location.getAltitude()) || Float.isInfinite(location.getAccuracy());
    }
}

