/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.telemetry.location.LocationEngineController;
import com.mapbox.android.telemetry.location.LocationUpdatesBroadcastReceiver;

class LocationEngineControllerImpl
implements LocationEngineController {
    private static final String TAG = "LocationController";
    private static final long DEFAULT_INTERVAL_IN_MILLISECONDS = 1000L;
    private static final long DEFAULT_MAX_WAIT_TIME = 5000L;
    private final Context applicationContext;
    private final LocationEngine locationEngine;
    private final LocationUpdatesBroadcastReceiver locationUpdatesBroadcastReceiver;

    LocationEngineControllerImpl(@NonNull Context context, @NonNull LocationEngine locationEngine, @NonNull LocationUpdatesBroadcastReceiver locationUpdatesBroadcastReceiver) {
        this.applicationContext = context;
        this.locationEngine = locationEngine;
        this.locationUpdatesBroadcastReceiver = locationUpdatesBroadcastReceiver;
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
        this.registerReceiver();
        this.requestLocationUpdates();
    }

    @Override
    public void onDestroy() {
        this.removeLocationUpdates();
        this.unregisterReceiver();
    }

    private void registerReceiver() {
        try {
            this.applicationContext.registerReceiver((BroadcastReceiver)this.locationUpdatesBroadcastReceiver, new IntentFilter("com.mapbox.android.telemetry.location.locationupdatespendingintent.action.LOCATION_UPDATED"));
        }
        catch (IllegalArgumentException iae) {
            Log.e((String)TAG, (String)iae.toString());
        }
    }

    private void unregisterReceiver() {
        try {
            this.applicationContext.unregisterReceiver((BroadcastReceiver)this.locationUpdatesBroadcastReceiver);
        }
        catch (IllegalArgumentException iae) {
            Log.e((String)TAG, (String)iae.toString());
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void requestLocationUpdates() {
        if (!this.checkPermissions()) {
            Log.w((String)TAG, (String)"Location permissions are not granted");
            return;
        }
        try {
            this.locationEngine.requestLocationUpdates(LocationEngineControllerImpl.createRequest(1000L), this.getPendingIntent());
        }
        catch (SecurityException se) {
            Log.e((String)TAG, (String)se.toString());
        }
    }

    private void removeLocationUpdates() {
        this.locationEngine.removeLocationUpdates(this.getPendingIntent());
    }

    private PendingIntent getPendingIntent() {
        Intent intent = new Intent("com.mapbox.android.telemetry.location.locationupdatespendingintent.action.LOCATION_UPDATED");
        return PendingIntent.getBroadcast((Context)this.applicationContext, (int)0, (Intent)intent, (int)0x8000000);
    }

    private boolean isPermissionGranted(String permission2) {
        return ContextCompat.checkSelfPermission((Context)this.applicationContext, (String)permission2) == 0;
    }

    private boolean checkPermissions() {
        return this.isPermissionGranted("android.permission.ACCESS_FINE_LOCATION") || this.isPermissionGranted("android.permission.ACCESS_COARSE_LOCATION");
    }

    private static LocationEngineRequest createRequest(long interval) {
        return new LocationEngineRequest.Builder(interval).setPriority(3).setMaxWaitTime(5000L).build();
    }
}

