/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.mapbox.android.core.crashreporter.CrashReport;
import com.mapbox.android.core.crashreporter.CrashReportFactory;
import com.mapbox.android.telemetry.CrashEvent;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.errors.ErrorUtils;
import java.util.Map;
import java.util.Set;

public class MapboxCrashReporter {
    private final MapboxTelemetry telemetry;
    private final CrashReportFactory crashReportFactory;

    public MapboxCrashReporter(@NonNull MapboxTelemetry telemetry, @NonNull String mapboxPackage, @NonNull String mapboxModuleVersion, @NonNull Set<String> allowedStacktracePrefixes) {
        this.telemetry = telemetry;
        this.crashReportFactory = new CrashReportFactory(MapboxTelemetry.applicationContext, mapboxPackage, mapboxModuleVersion, allowedStacktracePrefixes);
    }

    MapboxCrashReporter(@NonNull MapboxTelemetry telemetry, @NonNull CrashReportFactory crashReportFactory) {
        this.telemetry = telemetry;
        this.crashReportFactory = crashReportFactory;
    }

    public boolean reportError(@NonNull Throwable throwable) {
        return this.reportError(throwable, null);
    }

    public boolean reportError(@NonNull Throwable throwable, @Nullable Map<String, String> customData) {
        CrashReport report = this.crashReportFactory.createReportForNonFatal(throwable, customData);
        if (report != null) {
            CrashEvent nonFatalErrorEvent = this.parseReportAsEvent(report);
            return this.telemetry.pushToQueue(nonFatalErrorEvent);
        }
        return false;
    }

    @VisibleForTesting
    CrashEvent parseReportAsEvent(CrashReport report) {
        return ErrorUtils.parseJsonCrashEvent(report.toJson());
    }
}

