/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import android.location.Location;
import com.mapbox.android.telemetry.LocationEvent;
import com.mapbox.android.telemetry.location.SessionIdentifier;
import java.math.BigDecimal;

public class LocationMapper {
    private static final int SEVEN_DIGITS_AFTER_DECIMAL = 7;
    private static final double MIN_LONGITUDE = -180.0;
    private static final double MAX_LONGITUDE = 180.0;
    private SessionIdentifier sessionIdentifier = new SessionIdentifier();

    @Deprecated
    public static LocationEvent create(Location location, String sessionId) {
        return LocationMapper.createLocationEvent(location, "unknown", sessionId);
    }

    public static LocationEvent create(Location location, String applicationState, String sessionId) {
        return LocationMapper.createLocationEvent(location, applicationState, sessionId);
    }

    public LocationEvent from(Location location, String applicationState) {
        return LocationMapper.createLocationEvent(location, applicationState, this.sessionIdentifier.getSessionId());
    }

    public void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        this.sessionIdentifier = sessionIdentifier;
    }

    private static LocationEvent createLocationEvent(Location location, String applicationState, String sessionId) {
        double latitudeScaled = LocationMapper.round(location.getLatitude());
        double longitudeScaled = LocationMapper.round(location.getLongitude());
        double longitudeWrapped = LocationMapper.wrapLongitude(longitudeScaled);
        LocationEvent locationEvent = new LocationEvent(sessionId, latitudeScaled, longitudeWrapped, applicationState);
        LocationMapper.addAltitudeIfPresent(location, locationEvent);
        LocationMapper.addAccuracyIfPresent(location, locationEvent);
        return locationEvent;
    }

    private static double round(double value) {
        return new BigDecimal(value).setScale(7, 1).doubleValue();
    }

    private static double wrapLongitude(double longitude) {
        double wrapped = longitude;
        if (longitude < -180.0 || longitude > 180.0) {
            wrapped = LocationMapper.wrap(longitude, -180.0, 180.0);
        }
        return wrapped;
    }

    private static double wrap(double value, double min, double max) {
        double delta = max - min;
        double firstMod = (value - min) % delta;
        double secondMod = (firstMod + delta) % delta;
        return secondMod + min;
    }

    private static void addAltitudeIfPresent(Location location, LocationEvent locationEvent) {
        if (location.hasAltitude()) {
            double altitudeRounded = Math.round(location.getAltitude());
            locationEvent.setAltitude(altitudeRounded);
        }
    }

    private static void addAccuracyIfPresent(Location location, LocationEvent locationEvent) {
        if (location.hasAccuracy()) {
            float accuracyRounded = Math.round(location.getAccuracy());
            locationEvent.setAccuracy(Float.valueOf(accuracyRounded));
        }
    }
}

