/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.android.telemetry.AppStateUtils;
import com.mapbox.android.telemetry.LogUtils;

public class MapboxTelemetryService
extends Service {
    private final String TAG = "MapboxTelemetryService";
    private final IBinder binder = new Binder();
    private Application application = null;
    private final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
            MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_CREATED);
        }

        public void onActivityStarted(@NonNull Activity activity) {
            MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_STARTED);
        }

        public void onActivityResumed(@NonNull Activity activity) {
            MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_RESUMED);
        }

        public void onActivityPaused(@NonNull Activity activity) {
            MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_PAUSED);
        }

        public void onActivityStopped(@NonNull Activity activity) {
            MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_STOPPED);
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
            MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_SAVE_INSTANCE_STATE);
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
            MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_DESTROYED);
        }
    };

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    private void saveActivityState(AppStateUtils.ActivityState state) {
        LogUtils.v("MapboxTelemetryService", "Activity state: " + (Object)((Object)state), new Object[0]);
        AppStateUtils.saveActivityState((Context)this, state);
    }

    private void resetActivityStateToUnknown() {
        AppStateUtils.saveActivityState((Context)this, AppStateUtils.ActivityState.ACTIVITY_STATE_UNKNOWN);
    }

    public void onCreate() {
        LogUtils.d("MapboxTelemetryService", "Starting telemetry service...", new Object[0]);
        this.resetActivityStateToUnknown();
        this.application = this.getApplication();
        this.application.registerActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
    }

    public void onDestroy() {
        LogUtils.d("MapboxTelemetryService", "Stopping telemetry service..", new Object[0]);
        this.application.unregisterActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
    }

    public class Binder
    extends android.os.Binder {
        public MapboxTelemetryService getService() {
            return MapboxTelemetryService.this;
        }
    }
}

