/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.util.Log;

public class LogUtils {
    private static final int maxLogLevel = 3;

    public static boolean isLoggable(String tag, int level) {
        if (3 > level) {
            return false;
        }
        return Log.isLoggable((String)tag, (int)level);
    }

    public static int v(String tag, String format, Object ... args) {
        return LogUtils.isLoggable(tag, 2) ? Log.v((String)tag, (String)String.format(format, args)) : 0;
    }

    public static int d(String tag, String format, Object ... args) {
        return LogUtils.isLoggable(tag, 3) ? Log.d((String)tag, (String)String.format(format, args)) : 0;
    }

    private static int i(String tag, String format, Object ... args) {
        return LogUtils.isLoggable(tag, 4) ? Log.i((String)tag, (String)String.format(format, args)) : 0;
    }

    public static int w(String tag, String format, Object ... args) {
        return LogUtils.isLoggable(tag, 5) ? Log.w((String)tag, (String)String.format(format, args)) : 0;
    }

    public static int w(String tag, Throwable tr, String format, Object ... args) {
        return LogUtils.isLoggable(tag, 5) ? Log.w((String)tag, (String)String.format(format, args), (Throwable)tr) : 0;
    }

    public static int e(String tag, String format, Object ... args) {
        return LogUtils.isLoggable(tag, 6) ? Log.e((String)tag, (String)String.format(format, args)) : 0;
    }

    public static int e(String tag, Throwable tr, String format, Object ... args) {
        return LogUtils.isLoggable(tag, 6) ? Log.e((String)tag, (String)String.format(format, args), (Throwable)tr) : 0;
    }
}

