/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.TelemetryUtils;

public class AppUserTurnstile
extends Event
implements Parcelable {
    private static final String APP_USER_TURNSTILE = "appUserTurnstile";
    private static final String OPERATING_SYSTEM = "Android - " + Build.VERSION.RELEASE;
    private static final String APPLICATION_CONTEXT_CANT_BE_NULL = "Create a MapboxTelemetry instance before calling this method.";
    private final String event;
    private final String created;
    private final String userId;
    @SerializedName(value="enabled.telemetry")
    private final boolean enabledTelemetry;
    private final String device;
    private final String sdkIdentifier;
    private final String sdkVersion;
    private final String model;
    private final String operatingSystem;
    private String skuId;
    public static final Parcelable.Creator<AppUserTurnstile> CREATOR = new Parcelable.Creator<AppUserTurnstile>(){

        public AppUserTurnstile createFromParcel(Parcel in) {
            return new AppUserTurnstile(in);
        }

        public AppUserTurnstile[] newArray(int size) {
            return new AppUserTurnstile[size];
        }
    };

    public AppUserTurnstile(String sdkIdentifier, String sdkVersion) {
        this(sdkIdentifier, sdkVersion, true);
    }

    AppUserTurnstile(String sdkIdentifier, String sdkVersion, boolean isFromPreferences) {
        this.checkApplicationContext();
        this.event = APP_USER_TURNSTILE;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.userId = TelemetryUtils.retrieveVendorId();
        TelemetryEnabler telemetryEnabler = new TelemetryEnabler(isFromPreferences);
        this.enabledTelemetry = TelemetryEnabler.TELEMETRY_STATES.get((Object)telemetryEnabler.obtainTelemetryState());
        this.device = Build.DEVICE;
        this.sdkIdentifier = sdkIdentifier;
        this.sdkVersion = sdkVersion;
        this.model = Build.MODEL;
        this.operatingSystem = OPERATING_SYSTEM;
    }

    @Nullable
    public String getSkuId() {
        return this.skuId;
    }

    public void setSkuId(@NonNull String skuId) {
        if (skuId == null || skuId.length() == 0) {
            return;
        }
        this.skuId = skuId;
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.TURNSTILE;
    }

    private AppUserTurnstile(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.userId = in.readString();
        this.enabledTelemetry = in.readByte() != 0;
        this.device = in.readString();
        this.sdkIdentifier = in.readString();
        this.sdkVersion = in.readString();
        this.model = in.readString();
        this.operatingSystem = in.readString();
        this.skuId = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        dest.writeString(this.userId);
        dest.writeByte((byte)(this.enabledTelemetry ? 1 : 0));
        dest.writeString(this.device);
        dest.writeString(this.sdkIdentifier);
        dest.writeString(this.sdkVersion);
        dest.writeString(this.model);
        dest.writeString(this.operatingSystem);
        dest.writeString(this.skuId);
    }

    private void checkApplicationContext() {
        if (MapboxTelemetry.applicationContext == null) {
            throw new IllegalStateException(APPLICATION_CONTEXT_CANT_BE_NULL);
        }
    }
}

