/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.crash;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mapbox.android.core.FileUtils;
import com.mapbox.android.telemetry.CrashEvent;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class CrashReporterClient {
    private static final String LOG_TAG = "CrashReporterClient";
    private static final String CRASH_REPORTER_CLIENT_USER_AGENT = "mapbox-android-crash";
    private final SharedPreferences sharedPreferences;
    private final MapboxTelemetry telemetry;
    private final HashSet<String> crashHashSet = new HashSet();
    private final HashMap<CrashEvent, File> eventFileHashMap = new HashMap();
    private File[] crashReports;
    private int fileCursor;
    private boolean isDebug;

    @VisibleForTesting
    CrashReporterClient(@NonNull SharedPreferences sharedPreferences, @NonNull MapboxTelemetry telemetry, File[] crashReports) {
        this.sharedPreferences = sharedPreferences;
        this.telemetry = telemetry;
        this.crashReports = crashReports;
        this.fileCursor = 0;
        this.isDebug = false;
    }

    static CrashReporterClient create(@NonNull Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("MapboxCrashReporterPrefs", 0);
        return new CrashReporterClient(sharedPreferences, new MapboxTelemetry(context, "", String.format("%s/%s", CRASH_REPORTER_CLIENT_USER_AGENT, "4.7.1")), new File[0]);
    }

    CrashReporterClient loadFrom(@NonNull File rootDir) {
        this.fileCursor = 0;
        this.crashReports = FileUtils.listAllFiles((File)rootDir);
        Arrays.sort(this.crashReports, new FileUtils.LastModifiedComparator());
        return this;
    }

    CrashReporterClient debug(boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    boolean isEnabled() {
        try {
            return this.sharedPreferences.getBoolean("mapbox.crash.enable", true);
        }
        catch (Exception ex) {
            Log.e((String)LOG_TAG, (String)ex.toString());
            return false;
        }
    }

    boolean hasNextEvent() {
        return this.fileCursor < this.crashReports.length;
    }

    boolean isDuplicate(CrashEvent crashEvent) {
        return this.crashHashSet.contains(crashEvent.getHash());
    }

    @NonNull
    CrashEvent nextEvent() {
        if (!this.hasNextEvent()) {
            throw new IllegalStateException("No more events can be read");
        }
        try {
            File file = this.crashReports[this.fileCursor];
            CrashEvent event = CrashReporterClient.parseJsonCrashEvent(FileUtils.readFromFile((File)file));
            if (event.isValid()) {
                this.eventFileHashMap.put(event, file);
            }
            CrashEvent crashEvent = event;
            return crashEvent;
        }
        catch (FileNotFoundException fileException) {
            throw new IllegalStateException("File cannot be read: " + fileException.toString());
        }
        finally {
            ++this.fileCursor;
        }
    }

    boolean send(CrashEvent event) {
        if (!event.isValid()) {
            return false;
        }
        AtomicBoolean success = new AtomicBoolean(this.isDebug);
        CountDownLatch latch = new CountDownLatch(1);
        return this.sendSync(event, success, latch);
    }

    boolean delete(CrashEvent event) {
        File file = this.eventFileHashMap.get(event);
        return file != null && file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean sendSync(CrashEvent event, AtomicBoolean status, CountDownLatch latch) {
        this.setupTelemetryListener(status, latch);
        this.telemetry.push(event);
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (status.get()) {
                this.crashHashSet.add(event.getHash());
            }
        }
        return status.get();
    }

    private void setupTelemetryListener(final AtomicBoolean success, final CountDownLatch latch) {
        this.telemetry.addTelemetryListener(new TelemetryListener(){

            @Override
            public void onHttpResponse(boolean successful, int code) {
                Log.d((String)CrashReporterClient.LOG_TAG, (String)("Response: " + code));
                success.set(successful);
                latch.countDown();
                CrashReporterClient.this.telemetry.removeTelemetryListener(this);
            }

            @Override
            public void onHttpFailure(String message) {
                Log.d((String)CrashReporterClient.LOG_TAG, (String)("Response: " + message));
                latch.countDown();
                CrashReporterClient.this.telemetry.removeTelemetryListener(this);
            }
        });
    }

    private static CrashEvent parseJsonCrashEvent(String json) {
        Gson gson = new GsonBuilder().create();
        try {
            return (CrashEvent)gson.fromJson(json, CrashEvent.class);
        }
        catch (JsonSyntaxException jse) {
            Log.e((String)LOG_TAG, (String)jse.toString());
            return new CrashEvent(null, null);
        }
    }
}

