/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.EnvironmentChain;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.ServerInformation;
import com.mapbox.android.telemetry.TelemetryClient;
import com.mapbox.android.telemetry.TelemetryClientSettings;
import com.mapbox.android.telemetry.TelemetryUtils;

class TelemetryClientFactory {
    private static final String LOG_TAG = "TelemetryClientFactory";
    private static final String RETRIEVING_APP_META_DATA_ERROR_MESSAGE = "Failed when retrieving app meta-data: %s";
    private final String accessToken;
    private final String userAgent;
    private final Logger logger;
    private final CertificateBlacklist certificateBlacklist;

    TelemetryClientFactory(String accessToken, String userAgent, Logger logger, CertificateBlacklist certificateBlacklist) {
        this.accessToken = accessToken;
        this.userAgent = userAgent;
        this.logger = logger;
        this.certificateBlacklist = certificateBlacklist;
    }

    TelemetryClient obtainTelemetryClient(Context context) {
        try {
            ApplicationInfo appInformation = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInformation != null && appInformation.metaData != null) {
                EnvironmentChain environmentChain = new EnvironmentChain();
                return this.buildClientFrom(environmentChain.setup().obtainServerInformation(appInformation.metaData), context);
            }
        }
        catch (Exception exception) {
            this.logger.error(LOG_TAG, String.format(RETRIEVING_APP_META_DATA_ERROR_MESSAGE, exception.getMessage()));
        }
        return this.buildTelemetryClient(Environment.COM, this.certificateBlacklist, context);
    }

    private TelemetryClient buildTelemetryClient(Environment environment, CertificateBlacklist certificateBlacklist, Context context) {
        return new TelemetryClient(this.accessToken, this.userAgent, TelemetryUtils.createReformedFullUserAgent(context), new TelemetryClientSettings.Builder(context).environment(environment).build(), this.logger, certificateBlacklist);
    }

    private TelemetryClient buildTelemetryClientCustom(ServerInformation serverInformation, CertificateBlacklist certificateBlacklist, Context context) {
        TelemetryClientSettings telemetryClientSettings = new TelemetryClientSettings.Builder(context).environment(serverInformation.getEnvironment()).baseUrl(TelemetryClientSettings.configureUrlHostname(serverInformation.getHostname())).build();
        return new TelemetryClient(serverInformation.getAccessToken(), this.userAgent, TelemetryUtils.createReformedFullUserAgent(context), telemetryClientSettings, this.logger, certificateBlacklist);
    }

    private TelemetryClient buildClientFrom(ServerInformation serverInformation, Context context) {
        Environment environment = serverInformation.getEnvironment();
        switch (environment) {
            case STAGING: {
                return this.buildTelemetryClientCustom(serverInformation, this.certificateBlacklist, context);
            }
        }
        return this.buildTelemetryClient(environment, this.certificateBlacklist, context);
    }
}

