/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.AlarmManager;
import android.content.Context;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.AlarmSchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.TelemetryUtils;

class SchedulerFlusherFactory {
    static final String SCHEDULER_FLUSHER_INTENT = "com.mapbox.scheduler_flusher";
    static long flushingPeriod = 180000L;
    private final Context context;
    private final AlarmReceiver alarmReceiver;

    SchedulerFlusherFactory(Context context, AlarmReceiver alarmReceiver) {
        this.context = context;
        this.alarmReceiver = alarmReceiver;
        this.checkUpdatePeriod(context);
    }

    SchedulerFlusher supply() {
        return new AlarmSchedulerFlusher(this.context, (AlarmManager)this.context.getSystemService("alarm"), this.alarmReceiver);
    }

    private void checkUpdatePeriod(Context context) {
        if (TelemetryUtils.adjustWakeUpMode(context)) {
            flushingPeriod = 600000L;
        }
    }
}

