/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class ConcurrentQueue<T> {
    private static final String TAG = "ConcurrentQueue";
    private final Queue<T> queue = new ConcurrentLinkedQueue<T>();

    ConcurrentQueue() {
    }

    boolean add(T event) {
        try {
            return this.queue.add(event);
        }
        catch (Exception exc) {
            Log.e((String)TAG, (String)exc.toString());
            return false;
        }
    }

    @Nullable
    T remove() {
        return this.queue.remove();
    }

    List<T> flush() {
        ArrayList<T> queuedEvents = new ArrayList<T>(this.queue.size());
        try {
            queuedEvents.addAll(this.queue);
            this.queue.clear();
        }
        catch (Exception exc) {
            Log.e((String)TAG, (String)exc.toString());
        }
        return queuedEvents;
    }

    int size() {
        return this.queue.size();
    }

    @VisibleForTesting
    Queue<T> obtainQueue() {
        return this.queue;
    }
}

