/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.crash;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.JobIntentService;
import android.util.Log;
import com.mapbox.android.core.FileUtils;
import com.mapbox.android.telemetry.CrashEvent;
import com.mapbox.android.telemetry.crash.CrashReporterClient;
import java.io.File;

public final class CrashReporterJobIntentService
extends JobIntentService {
    private static final String LOG_TAG = "CrashJobIntentService";
    private static final int JOB_ID = 666;

    static void enqueueWork(@NonNull Context context) {
        CrashReporterJobIntentService.enqueueWork((Context)context, CrashReporterJobIntentService.class, (int)666, (Intent)new Intent(context, CrashReporterJobIntentService.class));
    }

    protected void onHandleWork(@NonNull Intent intent) {
        Log.d((String)LOG_TAG, (String)"onHandleWork");
        try {
            File rootDirectory = FileUtils.getFile((Context)this.getApplicationContext(), (String)"com.mapbox.android.telemetry");
            if (!rootDirectory.exists()) {
                Log.w((String)LOG_TAG, (String)"Root directory doesn't exist");
                return;
            }
            this.handleCrashReports(CrashReporterClient.create(this.getApplicationContext()).loadFrom(rootDirectory));
        }
        catch (Throwable throwable) {
            Log.e((String)LOG_TAG, (String)throwable.toString());
        }
    }

    @VisibleForTesting
    void handleCrashReports(@NonNull CrashReporterClient client) {
        if (!client.isEnabled()) {
            Log.w((String)LOG_TAG, (String)"Crash reporter is disabled");
            return;
        }
        while (client.hasNextEvent()) {
            CrashEvent event = client.nextEvent();
            if (client.isDuplicate(event)) {
                Log.d((String)LOG_TAG, (String)("Skip duplicate crash in this batch: " + event.getHash()));
                client.delete(event);
                continue;
            }
            if (client.send(event)) {
                client.delete(event);
                continue;
            }
            Log.w((String)LOG_TAG, (String)"Failed to deliver crash event");
        }
    }
}

