/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;

public class VisionObjectDetectionEvent
extends Event
implements Parcelable {
    static final String VIS_OBJECT_DETECTION = "vision.objectDetection";
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="object_lat")
    private Double object_lat;
    @SerializedName(value="object_lon")
    private Double object_lon;
    @SerializedName(value="vehicle_lat")
    private Double vehicle_lat;
    @SerializedName(value="vehicle_lon")
    private Double vehicle_lon;
    @SerializedName(value="class")
    private String clazz;
    @SerializedName(value="sign_value")
    private String sign_value;
    @SerializedName(value="object_size_width")
    private Double object_size_width;
    @SerializedName(value="object_size_height")
    private Double object_size_height;
    @SerializedName(value="object_pos_height")
    private Double object_pos_height;
    @SerializedName(value="distance_from_camera")
    private Double distance_from_camera;
    public static final Parcelable.Creator<VisionObjectDetectionEvent> CREATOR = new Parcelable.Creator<VisionObjectDetectionEvent>(){

        public VisionObjectDetectionEvent createFromParcel(Parcel in) {
            return new VisionObjectDetectionEvent(in);
        }

        public VisionObjectDetectionEvent[] newArray(int size) {
            return new VisionObjectDetectionEvent[size];
        }
    };

    public VisionObjectDetectionEvent(String created) {
        this.event = VIS_OBJECT_DETECTION;
        this.created = created;
        this.object_lat = null;
        this.object_lon = null;
        this.vehicle_lat = null;
        this.vehicle_lon = null;
        this.clazz = null;
        this.sign_value = null;
        this.object_size_height = null;
        this.object_size_width = null;
        this.object_pos_height = null;
        this.distance_from_camera = null;
    }

    public String getEvent() {
        return this.event;
    }

    public String getCreated() {
        return this.created;
    }

    public double getObjectLatitude() {
        return this.object_lat;
    }

    public void setObjectLatitude(double latitude) {
        this.object_lat = latitude;
    }

    public double getObjectLongitude() {
        return this.object_lon;
    }

    public void setObjectLongitude(double longitude) {
        this.object_lon = longitude;
    }

    public double getVehicleLatitude() {
        return this.vehicle_lat;
    }

    public void setVehicleLatitude(double latitude) {
        this.vehicle_lat = latitude;
    }

    public double getVehicleLongitude() {
        return this.vehicle_lon;
    }

    public void setVehicleLongitude(double longitude) {
        this.vehicle_lon = longitude;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getSignValue() {
        return this.sign_value;
    }

    public void setSignValue(String sign_value) {
        this.sign_value = sign_value;
    }

    public double getObjectSizeWidth() {
        return this.object_size_width;
    }

    public void setObjectSizeWidth(double object_size_width) {
        this.object_size_width = object_size_width;
    }

    public double getObjectSizeHeight() {
        return this.object_size_height;
    }

    public void setObjectSizeHeight(double object_size_height) {
        this.object_size_height = object_size_height;
    }

    public double getObjectPositionHeight() {
        return this.object_pos_height;
    }

    public void setObjectPositionHeight(double object_pos_height) {
        this.object_pos_height = object_pos_height;
    }

    public double getDistanceFromCamera() {
        return this.distance_from_camera;
    }

    public void setDistanceFromCamera(double distance_from_camera) {
        this.distance_from_camera = distance_from_camera;
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.VIS_OBJ_DETECTION;
    }

    private VisionObjectDetectionEvent(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.object_lat = VisionObjectDetectionEvent.readDoubleIfNotNull(in);
        this.object_lon = VisionObjectDetectionEvent.readDoubleIfNotNull(in);
        this.vehicle_lat = VisionObjectDetectionEvent.readDoubleIfNotNull(in);
        this.vehicle_lon = VisionObjectDetectionEvent.readDoubleIfNotNull(in);
        this.clazz = VisionObjectDetectionEvent.readStringIfNotNull(in);
        this.sign_value = VisionObjectDetectionEvent.readStringIfNotNull(in);
        this.object_size_width = VisionObjectDetectionEvent.readDoubleIfNotNull(in);
        this.object_size_height = VisionObjectDetectionEvent.readDoubleIfNotNull(in);
        this.object_pos_height = VisionObjectDetectionEvent.readDoubleIfNotNull(in);
        this.distance_from_camera = VisionObjectDetectionEvent.readDoubleIfNotNull(in);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(dest, this.object_lat);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(dest, this.object_lon);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(dest, this.vehicle_lat);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(dest, this.vehicle_lon);
        VisionObjectDetectionEvent.writeStringIfNotNull(dest, this.clazz);
        VisionObjectDetectionEvent.writeStringIfNotNull(dest, this.sign_value);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(dest, this.object_size_width);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(dest, this.object_size_height);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(dest, this.object_pos_height);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(dest, this.distance_from_camera);
    }

    private static void writeDoubleIfNotNull(Parcel parcel, Double value) {
        parcel.writeByte((byte)(value != null ? 1 : 0));
        if (value != null) {
            parcel.writeDouble(value.doubleValue());
        }
    }

    private static void writeStringIfNotNull(Parcel parcel, String value) {
        parcel.writeByte((byte)(value != null ? 1 : 0));
        if (value != null) {
            parcel.writeString(value);
        }
    }

    private static Double readDoubleIfNotNull(Parcel parcel) {
        return parcel.readByte() == 0 ? null : Double.valueOf(parcel.readDouble());
    }

    private static String readStringIfNotNull(Parcel parcel) {
        return parcel.readByte() == 0 ? null : parcel.readString();
    }
}

