/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.mapbox.android.telemetry.ConfigurationChangeHandler;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.EnvironmentChain;
import com.mapbox.android.telemetry.EnvironmentResolver;
import com.mapbox.android.telemetry.ServerInformation;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

class ConfigurationClient
implements Callback {
    private static final String LOG_TAG = "ConfigurationClient";
    private static final String USER_AGENT_REQUEST_HEADER = "User-Agent";
    private static final String HTTPS_SCHEME = "https";
    private static final String EVENT_CONFIG_SEGMENT = "events-config";
    private static final String ACCESS_TOKEN_QUERY_PARAMETER = "access_token";
    private static final String COM_CONFIG_ENDPOINT = "api.mapbox.com";
    private static final String CHINA_CONFIG_ENDPOINT = "api.mapbox.cn";
    private static final String MAPBOX_CONFIG_SYNC_KEY_TIMESTAMP = "mapboxConfigSyncTimestamp";
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final Map<Environment, String> ENDPOINTS = new HashMap<Environment, String>(){
        {
            this.put(Environment.COM, ConfigurationClient.COM_CONFIG_ENDPOINT);
            this.put(Environment.STAGING, ConfigurationClient.COM_CONFIG_ENDPOINT);
            this.put(Environment.CHINA, ConfigurationClient.CHINA_CONFIG_ENDPOINT);
        }
    };
    private final Context context;
    private final String userAgent;
    private final String accessToken;
    private final OkHttpClient client;
    private final List<ConfigurationChangeHandler> handlers;

    ConfigurationClient(Context context, String userAgent, String accessToken, OkHttpClient client) {
        this.context = context;
        this.userAgent = userAgent;
        this.accessToken = accessToken;
        this.client = client;
        this.handlers = new CopyOnWriteArrayList<ConfigurationChangeHandler>();
    }

    void addHandler(ConfigurationChangeHandler handler) {
        this.handlers.add(handler);
    }

    boolean shouldUpdate() {
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences(this.context);
        long lastUpdateTime = sharedPreferences.getLong(MAPBOX_CONFIG_SYNC_KEY_TIMESTAMP, 0L);
        long millisecondDiff = System.currentTimeMillis() - lastUpdateTime;
        return millisecondDiff >= 86400000L;
    }

    void update() {
        HttpUrl requestUrl = ConfigurationClient.generateRequestUrl(this.context, this.accessToken);
        Request request = new Request.Builder().url(requestUrl).header(USER_AGENT_REQUEST_HEADER, this.userAgent).build();
        this.client.newCall(request).enqueue((Callback)this);
    }

    public void onFailure(Call call, IOException e) {
        this.saveTimestamp();
    }

    public void onResponse(Call call, Response response) throws IOException {
        this.saveTimestamp();
        if (response == null) {
            return;
        }
        ResponseBody body = response.body();
        if (body == null) {
            return;
        }
        for (ConfigurationChangeHandler handler : this.handlers) {
            handler.onUpdate(body.string());
        }
    }

    private void saveTimestamp() {
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences(this.context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(MAPBOX_CONFIG_SYNC_KEY_TIMESTAMP, System.currentTimeMillis());
        editor.apply();
    }

    private static HttpUrl generateRequestUrl(Context context, String accessToken) {
        return new HttpUrl.Builder().scheme(HTTPS_SCHEME).host(ConfigurationClient.determineConfigEndpoint(context)).addPathSegment(EVENT_CONFIG_SEGMENT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, accessToken).build();
    }

    private static String determineConfigEndpoint(Context context) {
        EnvironmentChain environmentChain = new EnvironmentChain();
        EnvironmentResolver setupChain = environmentChain.setup();
        try {
            ApplicationInfo appInformation = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInformation != null && appInformation.metaData != null) {
                ServerInformation serverInformation = setupChain.obtainServerInformation(appInformation.metaData);
                return ENDPOINTS.get((Object)serverInformation.getEnvironment());
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Log.e((String)LOG_TAG, (String)exception.getMessage());
        }
        return COM_CONFIG_ENDPOINT;
    }
}

