/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mapbox.android.telemetry.ArriveEventSerializer;
import com.mapbox.android.telemetry.Attachment;
import com.mapbox.android.telemetry.AttachmentListener;
import com.mapbox.android.telemetry.AttachmentMetadata;
import com.mapbox.android.telemetry.CancelEventSerializer;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.DepartEventSerializer;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FasterRouteEventSerializer;
import com.mapbox.android.telemetry.FeedbackEventSerializer;
import com.mapbox.android.telemetry.FileAttachment;
import com.mapbox.android.telemetry.FileData;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.NavigationArriveEvent;
import com.mapbox.android.telemetry.NavigationCancelEvent;
import com.mapbox.android.telemetry.NavigationDepartEvent;
import com.mapbox.android.telemetry.NavigationFasterRouteEvent;
import com.mapbox.android.telemetry.NavigationFeedbackEvent;
import com.mapbox.android.telemetry.NavigationRerouteEvent;
import com.mapbox.android.telemetry.RerouteEventSerializer;
import com.mapbox.android.telemetry.TelemetryClientSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

class TelemetryClient {
    private static final String LOG_TAG = "TelemetryClient";
    private static final MediaType JSON;
    private static final String EVENTS_ENDPOINT = "/events/v2";
    private static final String ATTACHMENTS_ENDPOINT = "/attachments/v1";
    private static final String USER_AGENT_REQUEST_HEADER = "User-Agent";
    private static final String ACCESS_TOKEN_QUERY_PARAMETER = "access_token";
    private static final String EXTRA_DEBUGGING_LOG = "Sending POST to %s with %d event(s) (user agent: %s) with payload: %s";
    private static final String BOUNDARY = "--01ead4a5-7a67-4703-ad02-589886e00923";
    private String accessToken;
    private String userAgent;
    private TelemetryClientSettings setting;
    private final Logger logger;
    private CertificateBlacklist certificateBlacklist;
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    TelemetryClient(String string, String string2, TelemetryClientSettings telemetryClientSettings, Logger logger, CertificateBlacklist certificateBlacklist) {
        void certificateBlacklist2;
        void logger2;
        void setting;
        void userAgent;
        void accessToken;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        this.accessToken = accessToken;
        this.userAgent = userAgent;
        this.setting = setting;
        this.logger = logger2;
        this.certificateBlacklist = certificateBlacklist2;
        blArray[0] = true;
    }

    /*
     * WARNING - void declaration
     */
    void updateAccessToken(String string) {
        void accessToken;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        this.accessToken = accessToken;
        blArray[1] = true;
    }

    /*
     * WARNING - void declaration
     */
    void updateUserAgent(String string) {
        void userAgent;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        this.userAgent = userAgent;
        blArray[2] = true;
    }

    /*
     * WARNING - void declaration
     */
    void sendEvents(List<Event> list, Callback callback) {
        void callback2;
        void events;
        void batch;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        ArrayList arrayList = new ArrayList();
        blArray[3] = true;
        batch.addAll(events);
        blArray[4] = true;
        this.sendBatch((List<Event>)batch, (Callback)callback2);
        blArray[5] = true;
    }

    /*
     * WARNING - void declaration
     */
    void sendAttachment(Attachment attachment, CopyOnWriteArraySet<AttachmentListener> copyOnWriteArraySet) {
        void attachmentListeners;
        void request;
        void client;
        void requestBody;
        void requestUrl;
        void baseUrl;
        void gson;
        void fileIds;
        HttpUrl fileData;
        void requestBodyBuilder;
        HttpUrl attachmentMetadata;
        void metadataList;
        RequestBody fileAttachment;
        void visionAttachments;
        void attachment2;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        List<FileAttachment> list = attachment2.getAttachments();
        blArray[6] = true;
        ArrayList arrayList = new ArrayList();
        blArray[7] = true;
        ArrayList arrayList2 = new ArrayList();
        blArray[8] = true;
        blArray[9] = true;
        MultipartBody.Builder builder = new MultipartBody.Builder(BOUNDARY).setType(MultipartBody.FORM);
        blArray[10] = true;
        Gson gson2 = visionAttachments.iterator();
        blArray[11] = true;
        while (gson2.hasNext()) {
            FileAttachment fileAttachment2 = (FileAttachment)gson2.next();
            blArray[12] = true;
            FileData fileData2 = fileAttachment.getFileData();
            blArray[13] = true;
            AttachmentMetadata attachmentMetadata2 = fileAttachment.getAttachmentMetadata();
            blArray[14] = true;
            metadataList.add(attachmentMetadata);
            blArray[15] = true;
            blArray[16] = true;
            blArray[17] = true;
            requestBodyBuilder.addFormDataPart("file", attachmentMetadata.getName(), RequestBody.create((MediaType)fileData.getType(), (File)new File(fileData.getFilePath())));
            blArray[18] = true;
            fileIds.add(attachmentMetadata.getFileId());
            blArray[19] = true;
        }
        gson2 = new Gson();
        blArray[20] = true;
        requestBodyBuilder.addFormDataPart("attachments", gson.toJson((Object)metadataList));
        blArray[21] = true;
        fileAttachment = this.reverseMultiForm((MultipartBody.Builder)requestBodyBuilder);
        blArray[22] = true;
        fileData = this.setting.getBaseUrl();
        blArray[23] = true;
        blArray[24] = true;
        blArray[25] = true;
        attachmentMetadata = baseUrl.newBuilder(ATTACHMENTS_ENDPOINT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, this.accessToken).build();
        blArray[26] = true;
        if (!this.isExtraDebuggingNeeded()) {
            blArray[27] = true;
        } else {
            blArray[28] = true;
            this.logger.debug(LOG_TAG, String.format(Locale.US, EXTRA_DEBUGGING_LOG, requestUrl, visionAttachments.size(), this.userAgent, metadataList));
            blArray[29] = true;
        }
        blArray[30] = true;
        blArray[31] = true;
        blArray[32] = true;
        blArray[33] = true;
        Request request2 = new Request.Builder().url((HttpUrl)requestUrl).header(USER_AGENT_REQUEST_HEADER, this.userAgent).post((RequestBody)requestBody).build();
        blArray[34] = true;
        OkHttpClient okHttpClient = this.setting.getAttachmentClient(this.certificateBlacklist);
        blArray[35] = true;
        client.newCall((Request)request).enqueue(new Callback(this, (CopyOnWriteArraySet)attachmentListeners, (List)fileIds){
            final /* synthetic */ CopyOnWriteArraySet val$attachmentListeners;
            final /* synthetic */ List val$fileIds;
            final /* synthetic */ TelemetryClient this$0;
            private static transient /* synthetic */ boolean[] $jacocoData;
            {
                void this$0;
                boolean[] blArray = 1.$jacocoInit();
                this.this$0 = this$0;
                this.val$attachmentListeners = copyOnWriteArraySet;
                this.val$fileIds = list;
                blArray[0] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onFailure(Call call, IOException iOException) {
                boolean[] blArray = 1.$jacocoInit();
                Iterator iterator = this.val$attachmentListeners.iterator();
                blArray[1] = true;
                while (iterator.hasNext()) {
                    void exception;
                    void attachmentListener;
                    AttachmentListener attachmentListener2 = (AttachmentListener)iterator.next();
                    blArray[2] = true;
                    attachmentListener.onAttachmentFailure(exception.getMessage(), this.val$fileIds);
                    blArray[3] = true;
                }
                blArray[4] = true;
            }

            /*
             * WARNING - void declaration
             */
            public void onResponse(Call call, Response response) {
                boolean[] blArray = 1.$jacocoInit();
                Iterator iterator = this.val$attachmentListeners.iterator();
                blArray[5] = true;
                while (iterator.hasNext()) {
                    void response2;
                    void attachmentListener;
                    AttachmentListener attachmentListener2 = (AttachmentListener)iterator.next();
                    blArray[6] = true;
                    attachmentListener.onAttachmentResponse(response2.message(), response2.code(), this.val$fileIds);
                    blArray[7] = true;
                }
                blArray[8] = true;
            }

            private static /* synthetic */ boolean[] $jacocoInit() {
                boolean[] blArray = $jacocoData;
                if ($jacocoData == null) {
                    blArray = $jacocoData = Offline.getProbes((long)3046349642596035255L, (String)"com/mapbox/android/telemetry/TelemetryClient$1", (int)9);
                }
                return blArray;
            }
        });
        blArray[36] = true;
    }

    /*
     * WARNING - void declaration
     */
    void updateDebugLoggingEnabled(boolean bl) {
        void debugLoggingEnabled;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        this.setting = this.setting.toBuilder().debugLoggingEnabled((boolean)debugLoggingEnabled).build();
        blArray[37] = true;
    }

    String obtainAccessToken() {
        boolean[] blArray = TelemetryClient.$jacocoInit();
        blArray[38] = true;
        return this.accessToken;
    }

    TelemetryClientSettings obtainSetting() {
        boolean[] blArray = TelemetryClient.$jacocoInit();
        blArray[39] = true;
        return this.setting;
    }

    /*
     * WARNING - void declaration
     */
    private void sendBatch(List<Event> list, Callback callback) {
        void callback2;
        void request;
        void client;
        void body;
        void url;
        void baseUrl;
        void payload;
        void batch;
        void gson;
        void gsonBuilder;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        GsonBuilder gsonBuilder2 = this.configureGsonBuilder();
        blArray[40] = true;
        Gson gson2 = gsonBuilder.create();
        blArray[41] = true;
        String string = gson.toJson((Object)batch);
        blArray[42] = true;
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)payload);
        blArray[43] = true;
        HttpUrl httpUrl = this.setting.getBaseUrl();
        blArray[44] = true;
        blArray[45] = true;
        HttpUrl httpUrl2 = baseUrl.newBuilder(EVENTS_ENDPOINT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, this.accessToken).build();
        blArray[46] = true;
        if (!this.isExtraDebuggingNeeded()) {
            blArray[47] = true;
        } else {
            blArray[48] = true;
            this.logger.debug(LOG_TAG, String.format(Locale.US, EXTRA_DEBUGGING_LOG, url, batch.size(), this.userAgent, payload));
            blArray[49] = true;
        }
        blArray[50] = true;
        blArray[51] = true;
        blArray[52] = true;
        blArray[53] = true;
        Request request2 = new Request.Builder().url((HttpUrl)url).header(USER_AGENT_REQUEST_HEADER, this.userAgent).post((RequestBody)body).build();
        blArray[54] = true;
        OkHttpClient okHttpClient = this.setting.getClient(this.certificateBlacklist);
        blArray[55] = true;
        client.newCall((Request)request).enqueue((Callback)callback2);
        blArray[56] = true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isExtraDebuggingNeeded() {
        block2: {
            var1_1 = TelemetryClient.$jacocoInit();
            if (!this.setting.isDebugLoggingEnabled()) break block2;
            var1_1[57] = true;
            ** GOTO lbl8
        }
        if (this.setting.getEnvironment().equals((Object)Environment.STAGING)) {
            var1_1[58] = true;
lbl8:
            // 2 sources

            v0 = var1_1[59] = true;
        } else {
            v0 = false;
            var1_1[60] = true;
        }
        var1_1[61] = true;
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private GsonBuilder configureGsonBuilder() {
        void fasterRouteSerializer;
        void rerouteSerializer;
        void feedbackSerializer;
        void cancelSerializer;
        void departSerializer;
        void arriveSerializer;
        void gsonBuilder;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        GsonBuilder gsonBuilder2 = new GsonBuilder();
        blArray[62] = true;
        ArriveEventSerializer arriveEventSerializer = new ArriveEventSerializer();
        blArray[63] = true;
        gsonBuilder.registerTypeAdapter(NavigationArriveEvent.class, (Object)arriveSerializer);
        blArray[64] = true;
        DepartEventSerializer departEventSerializer = new DepartEventSerializer();
        blArray[65] = true;
        gsonBuilder.registerTypeAdapter(NavigationDepartEvent.class, (Object)departSerializer);
        blArray[66] = true;
        CancelEventSerializer cancelEventSerializer = new CancelEventSerializer();
        blArray[67] = true;
        gsonBuilder.registerTypeAdapter(NavigationCancelEvent.class, (Object)cancelSerializer);
        blArray[68] = true;
        FeedbackEventSerializer feedbackEventSerializer = new FeedbackEventSerializer();
        blArray[69] = true;
        gsonBuilder.registerTypeAdapter(NavigationFeedbackEvent.class, (Object)feedbackSerializer);
        blArray[70] = true;
        RerouteEventSerializer rerouteEventSerializer = new RerouteEventSerializer();
        blArray[71] = true;
        gsonBuilder.registerTypeAdapter(NavigationRerouteEvent.class, (Object)rerouteSerializer);
        blArray[72] = true;
        FasterRouteEventSerializer fasterRouteEventSerializer = new FasterRouteEventSerializer();
        blArray[73] = true;
        gsonBuilder.registerTypeAdapter(NavigationFasterRouteEvent.class, (Object)fasterRouteSerializer);
        blArray[74] = true;
        return gsonBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private RequestBody reverseMultiForm(MultipartBody.Builder builder) {
        void i;
        void multipartBody;
        MultipartBody.Builder builder2;
        boolean[] blArray = TelemetryClient.$jacocoInit();
        MultipartBody multipartBody2 = builder2.build();
        blArray[75] = true;
        blArray[76] = true;
        builder2 = new MultipartBody.Builder(BOUNDARY).setType(MultipartBody.FORM);
        blArray[77] = true;
        int n = multipartBody.size() - 1;
        blArray[78] = true;
        while (i > -1) {
            blArray[79] = true;
            builder2.addPart(multipartBody.part((int)i));
            --i;
            blArray[80] = true;
        }
        blArray[81] = true;
        return builder2.build();
    }

    static {
        boolean[] blArray = TelemetryClient.$jacocoInit();
        JSON = MediaType.parse((String)"application/json; charset=utf-8");
        blArray[82] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-4466269981188702390L, (String)"com/mapbox/android/telemetry/TelemetryClient", (int)83);
        }
        return blArray;
    }
}

