/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.mapbox.android.telemetry.MapboxTelemetry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import okio.Buffer;

public class TelemetryUtils {
    static final String MAPBOX_SHARED_PREFERENCES = "MapboxSharedPreferences";
    static final String MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID = "mapboxVendorId";
    private static final String KEY_META_DATA_WAKE_UP = "com.mapbox.AdjustWakeUp";
    private static final String DATE_AND_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String EMPTY_STRING = "";
    private static final String TWO_STRING_FORMAT = "%s %s";
    private static final String THREE_STRING_FORMAT = "%s/%s/%s";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final int UNAVAILABLE_BATTERY_LEVEL = -1;
    private static final int DEFAULT_BATTERY_LEVEL = -1;
    private static final int PERCENT_SCALE = 100;
    private static final String FOREGROUND = "Foreground";
    private static final String BACKGROUND = "Background";
    private static final String NO_STATE = "";
    private static final String SINGLE_CARRIER_RTT = "1xRTT";
    private static final String CODE_DIVISION_MULTIPLE_ACCESS = "CDMA";
    private static final String ENHANCED_DATA_GSM_EVOLUTION = "EDGE";
    private static final String ENHANCED_HIGH_RATE_PACKET_DATA = "EHRPD";
    private static final String EVOLUTION_DATA_OPTIMIZED_0 = "EVDO_0";
    private static final String EVOLUTION_DATA_OPTIMIZED_A = "EVDO_A";
    private static final String EVOLUTION_DATA_OPTIMIZED_B = "EVDO_B";
    private static final String GENERAL_PACKET_RADIO_SERVICE = "GPRS";
    private static final String HIGH_SPEED_DOWNLINK_PACKET_ACCESS = "HSDPA";
    private static final String HIGH_SPEED_PACKET_ACCESS = "HSPA";
    private static final String HIGH_SPEED_PACKET_ACCESS_PLUS = "HSPAP";
    private static final String HIGH_SPEED_UNLINK_PACKET_ACCESS = "HSUPA";
    private static final String INTEGRATED_DIGITAL_ENHANCED_NETWORK = "IDEN";
    private static final String LONG_TERM_EVOLUTION = "LTE";
    private static final String UNIVERSAL_MOBILE_TELCO_SERVICE = "UMTS";
    private static final String UNKNOWN = "Unknown";
    private static final Map<Integer, String> NETWORKS = new HashMap<Integer, String>(){
        {
            this.put(7, TelemetryUtils.SINGLE_CARRIER_RTT);
            this.put(4, TelemetryUtils.CODE_DIVISION_MULTIPLE_ACCESS);
            this.put(2, TelemetryUtils.ENHANCED_DATA_GSM_EVOLUTION);
            this.put(14, TelemetryUtils.ENHANCED_HIGH_RATE_PACKET_DATA);
            this.put(5, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_0);
            this.put(6, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_A);
            this.put(12, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_B);
            this.put(1, TelemetryUtils.GENERAL_PACKET_RADIO_SERVICE);
            this.put(8, TelemetryUtils.HIGH_SPEED_DOWNLINK_PACKET_ACCESS);
            this.put(10, TelemetryUtils.HIGH_SPEED_PACKET_ACCESS);
            this.put(15, TelemetryUtils.HIGH_SPEED_PACKET_ACCESS_PLUS);
            this.put(9, TelemetryUtils.HIGH_SPEED_UNLINK_PACKET_ACCESS);
            this.put(11, TelemetryUtils.INTEGRATED_DIGITAL_ENHANCED_NETWORK);
            this.put(13, TelemetryUtils.LONG_TERM_EVOLUTION);
            this.put(3, TelemetryUtils.UNIVERSAL_MOBILE_TELCO_SERVICE);
            this.put(0, TelemetryUtils.UNKNOWN);
        }
    };

    public static String toHumanReadableAscii(String s) {
        int c;
        int length = s.length();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            if (c > 31 && c < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(s, 0, i);
            for (int j = i; j < length; j += Character.charCount(c)) {
                c = s.codePointAt(j);
                buffer.writeUtf8CodePoint(c > 31 && c < 127 ? c : 63);
            }
            return buffer.readUtf8();
        }
        return s;
    }

    public static String obtainUniversalUniqueIdentifier() {
        String universalUniqueIdentifier = UUID.randomUUID().toString();
        return universalUniqueIdentifier;
    }

    static String obtainApplicationState() {
        ActivityManager activityManager = (ActivityManager)MapboxTelemetry.applicationContext.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return "";
        }
        String packageName = MapboxTelemetry.applicationContext.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return FOREGROUND;
        }
        return BACKGROUND;
    }

    static int obtainBatteryLevel() {
        Intent batteryStatus = TelemetryUtils.registerBatteryUpdates(MapboxTelemetry.applicationContext);
        if (batteryStatus == null) {
            return -1;
        }
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        return Math.round((float)level / (float)scale * 100.0f);
    }

    static boolean isPluggedIn() {
        Intent batteryStatus = TelemetryUtils.registerBatteryUpdates(MapboxTelemetry.applicationContext);
        if (batteryStatus == null) {
            return false;
        }
        int chargePlug = batteryStatus.getIntExtra("plugged", -1);
        boolean pluggedIntoUSB = chargePlug == 2;
        boolean pluggedIntoAC = chargePlug == 1;
        return pluggedIntoUSB || pluggedIntoAC;
    }

    static String obtainCellularNetworkType() {
        TelephonyManager telephonyManager = (TelephonyManager)MapboxTelemetry.applicationContext.getSystemService("phone");
        return NETWORKS.get(telephonyManager.getNetworkType());
    }

    static String obtainCurrentDate() {
        return dateFormat.format(new Date());
    }

    static String generateCreateDateFormatted(Date date) {
        return dateFormat.format(date);
    }

    static String createFullUserAgent(String userAgent, Context context) {
        String appIdentifier = TelemetryUtils.obtainApplicationIdentifier(context);
        String newUserAgent = TelemetryUtils.toHumanReadableAscii(String.format(DEFAULT_LOCALE, TWO_STRING_FORMAT, appIdentifier, userAgent));
        String fullUserAgent = TextUtils.isEmpty((CharSequence)appIdentifier) ? userAgent : newUserAgent;
        return fullUserAgent;
    }

    static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static String retrieveVendorId() {
        if (MapboxTelemetry.applicationContext == null) {
            return TelemetryUtils.updateVendorId();
        }
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences(MapboxTelemetry.applicationContext);
        String mapboxVendorId = sharedPreferences.getString(MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID, "");
        if (TelemetryUtils.isEmpty(mapboxVendorId)) {
            mapboxVendorId = TelemetryUtils.updateVendorId();
        }
        return mapboxVendorId;
    }

    static SharedPreferences obtainSharedPreferences(Context context) {
        return context.getSharedPreferences(MAPBOX_SHARED_PREFERENCES, 0);
    }

    private static String updateVendorId() {
        String uniqueId = TelemetryUtils.obtainUniversalUniqueIdentifier();
        if (MapboxTelemetry.applicationContext == null) {
            return uniqueId;
        }
        SharedPreferences sharedPreferences = TelemetryUtils.obtainSharedPreferences(MapboxTelemetry.applicationContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID, uniqueId);
        editor.apply();
        return uniqueId;
    }

    private static String obtainApplicationIdentifier(Context context) {
        try {
            String packageName = context.getPackageName();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            String appIdentifier = String.format(DEFAULT_LOCALE, THREE_STRING_FORMAT, packageName, packageInfo.versionName, packageInfo.versionCode);
            return appIdentifier;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static Intent registerBatteryUpdates(Context context) {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        return context.registerReceiver(null, filter);
    }

    static boolean isServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)MapboxTelemetry.applicationContext.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    static boolean adjustWakeUpMode() {
        try {
            ApplicationInfo appInformation = MapboxTelemetry.applicationContext.getPackageManager().getApplicationInfo(MapboxTelemetry.applicationContext.getPackageName(), 128);
            if (appInformation != null && appInformation.metaData != null) {
                boolean adjustWakeUp = appInformation.metaData.getBoolean(KEY_META_DATA_WAKE_UP, false);
                return adjustWakeUp;
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

