/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.JsonAdapter;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FeedbackData;
import com.mapbox.android.telemetry.FeedbackDataSerializer;
import com.mapbox.android.telemetry.LocationDataSerializer;
import com.mapbox.android.telemetry.NavigationLocationData;
import com.mapbox.android.telemetry.NavigationMetadata;
import com.mapbox.android.telemetry.NavigationMetadataSerializer;
import com.mapbox.android.telemetry.NavigationRerouteData;
import com.mapbox.android.telemetry.NavigationState;
import com.mapbox.android.telemetry.NavigationStepMetadata;
import com.mapbox.android.telemetry.RerouteDataSerializer;

class NavigationRerouteEvent
extends Event
implements Parcelable {
    private static final String NAVIGATION_REROUTE = "navigation.reroute";
    private final String event;
    @JsonAdapter(value=NavigationMetadataSerializer.class)
    private NavigationMetadata navigationMetadata;
    @JsonAdapter(value=RerouteDataSerializer.class)
    private NavigationRerouteData navigationRerouteData;
    @JsonAdapter(value=LocationDataSerializer.class)
    private NavigationLocationData navigationLocationData;
    @JsonAdapter(value=FeedbackDataSerializer.class)
    private FeedbackData feedbackData;
    private NavigationStepMetadata step = null;
    public static final Parcelable.Creator<NavigationRerouteEvent> CREATOR = new Parcelable.Creator<NavigationRerouteEvent>(){

        public NavigationRerouteEvent createFromParcel(Parcel in) {
            return new NavigationRerouteEvent(in);
        }

        public NavigationRerouteEvent[] newArray(int size) {
            return new NavigationRerouteEvent[size];
        }
    };

    NavigationRerouteEvent(NavigationState navigationState) {
        this.event = NAVIGATION_REROUTE;
        this.feedbackData = navigationState.getFeedbackData();
        this.navigationMetadata = navigationState.getNavigationMetadata();
        this.navigationRerouteData = navigationState.getNavigationRerouteData();
        this.navigationLocationData = navigationState.getNavigationLocationData();
        this.step = navigationState.getNavigationStepMetadata();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.NAV_REROUTE;
    }

    String getEvent() {
        return this.event;
    }

    NavigationLocationData getNavigationLocationData() {
        return this.navigationLocationData;
    }

    NavigationRerouteData getNavigationRerouteData() {
        return this.navigationRerouteData;
    }

    NavigationStepMetadata getStep() {
        return this.step;
    }

    FeedbackData getFeedbackData() {
        return this.feedbackData;
    }

    NavigationMetadata getNavigationMetadata() {
        return this.navigationMetadata;
    }

    private NavigationRerouteEvent(Parcel in) {
        this.event = in.readString();
        this.navigationMetadata = (NavigationMetadata)in.readParcelable(NavigationMetadata.class.getClassLoader());
        this.navigationLocationData = (NavigationLocationData)in.readParcelable(NavigationLocationData.class.getClassLoader());
        this.feedbackData = (FeedbackData)in.readParcelable(FeedbackData.class.getClassLoader());
        this.step = (NavigationStepMetadata)in.readParcelable(NavigationStepMetadata.class.getClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeParcelable((Parcelable)this.navigationMetadata, flags);
        dest.writeParcelable((Parcelable)this.navigationLocationData, flags);
        dest.writeParcelable((Parcelable)this.feedbackData, flags);
        dest.writeParcelable((Parcelable)this.step, flags);
    }

    public int describeContents() {
        return 0;
    }
}

