/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.JsonAdapter;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.NavigationMetadata;
import com.mapbox.android.telemetry.NavigationMetadataSerializer;
import com.mapbox.android.telemetry.NavigationNewData;
import com.mapbox.android.telemetry.NavigationRerouteData;
import com.mapbox.android.telemetry.NavigationState;
import com.mapbox.android.telemetry.NavigationStepMetadata;
import com.mapbox.android.telemetry.NewDataSerializer;

class NavigationFasterRouteEvent
extends Event
implements Parcelable {
    private static final String NAVIGATION_REROUTE_DATA_STATE_ILLEGAL_NULL = "NavigationRerouteData cannot be null.";
    private static final String NAVIGATION_FASTER_ROUTE = "navigation.fasterRoute";
    private final String event;
    @JsonAdapter(value=NavigationMetadataSerializer.class)
    private NavigationMetadata metadata = null;
    @JsonAdapter(value=NewDataSerializer.class)
    private NavigationNewData navigationNewData = null;
    private NavigationStepMetadata step = null;
    public static final Parcelable.Creator<NavigationFasterRouteEvent> CREATOR = new Parcelable.Creator<NavigationFasterRouteEvent>(){

        public NavigationFasterRouteEvent createFromParcel(Parcel in) {
            return new NavigationFasterRouteEvent(in);
        }

        public NavigationFasterRouteEvent[] newArray(int size) {
            return new NavigationFasterRouteEvent[size];
        }
    };

    NavigationFasterRouteEvent(NavigationState navigationState) {
        this.event = NAVIGATION_FASTER_ROUTE;
        NavigationRerouteData navigationRerouteData = navigationState.getNavigationRerouteData();
        this.check(navigationRerouteData);
        this.navigationNewData = navigationRerouteData.getNavigationNewData();
        this.step = navigationState.getNavigationStepMetadata();
        this.metadata = navigationState.getNavigationMetadata();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.NAV_FASTER_ROUTE;
    }

    String getEvent() {
        return this.event;
    }

    NavigationNewData getNavigationNewData() {
        return this.navigationNewData;
    }

    NavigationStepMetadata getStep() {
        return this.step;
    }

    NavigationMetadata getMetadata() {
        return this.metadata;
    }

    private NavigationFasterRouteEvent(Parcel in) {
        this.event = in.readString();
        this.navigationNewData = (NavigationNewData)in.readParcelable(NavigationNewData.class.getClassLoader());
        this.step = (NavigationStepMetadata)in.readParcelable(NavigationStepMetadata.class.getClassLoader());
        this.metadata = (NavigationMetadata)in.readParcelable(NavigationMetadata.class.getClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeParcelable((Parcelable)this.navigationNewData, flags);
        dest.writeParcelable((Parcelable)this.step, flags);
        dest.writeParcelable((Parcelable)this.metadata, flags);
    }

    public int describeContents() {
        return 0;
    }

    private void check(NavigationRerouteData navigationRerouteData) {
        if (navigationRerouteData == null) {
            throw new IllegalArgumentException(NAVIGATION_REROUTE_DATA_STATE_ILLEGAL_NULL);
        }
    }
}

