/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.JsonAdapter;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.NavigationMetadata;
import com.mapbox.android.telemetry.NavigationMetadataSerializer;
import com.mapbox.android.telemetry.NavigationState;

class NavigationDepartEvent
extends Event
implements Parcelable {
    private static final String NAVIGATION_DEPART = "navigation.depart";
    private final String event;
    @JsonAdapter(value=NavigationMetadataSerializer.class)
    private NavigationMetadata metadata;
    public static final Parcelable.Creator<NavigationDepartEvent> CREATOR = new Parcelable.Creator<NavigationDepartEvent>(){

        public NavigationDepartEvent createFromParcel(Parcel in) {
            return new NavigationDepartEvent(in);
        }

        public NavigationDepartEvent[] newArray(int size) {
            return new NavigationDepartEvent[size];
        }
    };

    NavigationDepartEvent(NavigationState navigationState) {
        this.event = NAVIGATION_DEPART;
        this.metadata = navigationState.getNavigationMetadata();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.NAV_DEPART;
    }

    String getEvent() {
        return this.event;
    }

    NavigationMetadata getMetadata() {
        return this.metadata;
    }

    private NavigationDepartEvent(Parcel in) {
        this.event = in.readString();
        this.metadata = (NavigationMetadata)in.readParcelable(NavigationMetadata.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeParcelable((Parcelable)this.metadata, flags);
    }
}

