/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mapbox.android.telemetry.NavigationFasterRouteEvent;
import java.lang.reflect.Type;
import java.util.Map;

class FasterRouteEventSerializer
implements JsonSerializer<NavigationFasterRouteEvent> {
    private static final String EVENT = "event";
    private static final String STEP = "step";

    FasterRouteEventSerializer() {
    }

    public JsonElement serialize(NavigationFasterRouteEvent src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject fasterRoute = new JsonObject();
        fasterRoute.addProperty(EVENT, src.getEvent());
        this.serializeMetadata(src, context, fasterRoute);
        this.serializeNewData(src, context, fasterRoute);
        this.serializeStep(src, context, fasterRoute);
        return fasterRoute;
    }

    private void serializeMetadata(NavigationFasterRouteEvent src, JsonSerializationContext context, JsonObject fasterRoute) {
        JsonObject metadata = context.serialize((Object)src.getMetadata()).getAsJsonObject();
        for (Map.Entry e : metadata.entrySet()) {
            fasterRoute.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeNewData(NavigationFasterRouteEvent src, JsonSerializationContext context, JsonObject fasterRoute) {
        JsonObject newData = context.serialize((Object)src.getNavigationNewData()).getAsJsonObject();
        for (Map.Entry e : newData.entrySet()) {
            fasterRoute.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeStep(NavigationFasterRouteEvent src, JsonSerializationContext context, JsonObject fasterRoute) {
        JsonElement step = context.serialize((Object)src.getStep());
        fasterRoute.add(STEP, step);
    }
}

