/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.TelemetryUtils;

public class MapOfflineEvent
extends Event
implements Parcelable {
    private static final String MAP_OFFLINE = "map.offline.download";
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="minZoom")
    private Double minZoom;
    @SerializedName(value="maxZoom")
    private Double maxZoom;
    @SerializedName(value="shapeForOfflineRegion")
    private String shapeForOfflineRegion;
    @SerializedName(value="sources")
    private String[] sources;
    public static final Parcelable.Creator<MapOfflineEvent> CREATOR = new Parcelable.Creator<MapOfflineEvent>(){

        public MapOfflineEvent createFromParcel(Parcel in) {
            return new MapOfflineEvent(in);
        }

        public MapOfflineEvent[] newArray(int size) {
            return new MapOfflineEvent[size];
        }
    };

    public void setMinZoom(Double minZoom) {
        this.minZoom = minZoom;
    }

    public void setMaxZoom(Double maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void setShapeForOfflineRegion(String shapeForOfflineRegion) {
        this.shapeForOfflineRegion = shapeForOfflineRegion;
    }

    public void setSources(String[] sources) {
        this.sources = sources;
    }

    MapOfflineEvent() {
        this.event = MAP_OFFLINE;
        this.created = TelemetryUtils.obtainCurrentDate();
    }

    private MapOfflineEvent(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.minZoom = in.readDouble();
        this.maxZoom = in.readDouble();
        this.shapeForOfflineRegion = in.readString();
        this.sources = in.createStringArray();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.MAP_OFFLINE;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        dest.writeDouble(this.minZoom.doubleValue());
        dest.writeDouble(this.maxZoom.doubleValue());
        dest.writeString(this.shapeForOfflineRegion);
        dest.writeStringArray(this.sources);
    }
}

