/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.mapbox.android.telemetry.EventCallback;
import com.mapbox.android.telemetry.LocationEvent;
import com.mapbox.android.telemetry.LocationMapper;
import com.mapbox.android.telemetry.SessionIdentifier;

class LocationReceiver
extends BroadcastReceiver {
    private static final String LOCATION_RECEIVED_INTENT_KEY = "location_received";
    private static final String ON_LOCATION_INTENT_EXTRA = "onLocation";
    static final String LOCATION_RECEIVER_INTENT = "com.mapbox.location_receiver";
    private final EventCallback callback;
    private LocationMapper locationMapper = null;

    LocationReceiver(@NonNull EventCallback callback) {
        this.callback = callback;
    }

    public void onReceive(Context context, Intent intent) {
        String locationReceived = intent.getStringExtra(LOCATION_RECEIVED_INTENT_KEY);
        if (ON_LOCATION_INTENT_EXTRA.equals(locationReceived)) {
            Location location = (Location)intent.getExtras().get("location");
            this.sendEvent(location);
        }
    }

    static Intent supplyIntent(Location location) {
        Intent locationIntent = new Intent(LOCATION_RECEIVER_INTENT);
        locationIntent.putExtra(LOCATION_RECEIVED_INTENT_KEY, ON_LOCATION_INTENT_EXTRA);
        locationIntent.putExtra("location", (Parcelable)location);
        return locationIntent;
    }

    void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        this.locationMapper.updateSessionIdentifier(sessionIdentifier);
    }

    private boolean sendEvent(Location location) {
        if (this.isThereAnyNaN(location) || this.isThereAnyInfinite(location)) {
            return false;
        }
        LocationMapper obtainLocationEvent = this.obtainLocationMapper();
        LocationEvent locationEvent = obtainLocationEvent.from(location);
        this.callback.onEventReceived(locationEvent);
        return true;
    }

    private boolean isThereAnyNaN(Location location) {
        return Double.isNaN(location.getLatitude()) || Double.isNaN(location.getLongitude()) || Double.isNaN(location.getAltitude()) || Float.isNaN(location.getAccuracy());
    }

    private boolean isThereAnyInfinite(Location location) {
        return Double.isInfinite(location.getLatitude()) || Double.isInfinite(location.getLongitude()) || Double.isInfinite(location.getAltitude()) || Float.isInfinite(location.getAccuracy());
    }

    private LocationMapper obtainLocationMapper() {
        if (this.locationMapper == null) {
            this.locationMapper = new LocationMapper();
        }
        return this.locationMapper;
    }
}

