/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.mapbox.android.telemetry.ConcurrentQueue;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FlushQueueCallback;
import java.util.List;

class EventsQueue {
    static final int SIZE_LIMIT = 180;
    private final FlushQueueCallback callback;
    final ConcurrentQueue<Event> queue;
    private boolean isTelemetryInitialized = false;

    EventsQueue(FlushQueueCallback callback) {
        this.callback = callback;
        this.queue = new ConcurrentQueue();
    }

    boolean push(Event event) {
        if (this.checkMaximumSize()) {
            if (!this.isTelemetryInitialized) {
                return this.enqueue(event);
            }
            this.callback.onFullQueueFlush(this.queue, event);
            return false;
        }
        return this.queue.add(event);
    }

    List<Event> flush() {
        return this.queue.flush();
    }

    void setTelemetryInitialized(boolean telemetryInitialized) {
        this.isTelemetryInitialized = telemetryInitialized;
    }

    private boolean enqueue(Event event) {
        return this.queue.enqueue(event);
    }

    private boolean checkMaximumSize() {
        return this.queue.size() >= 180;
    }
}

