/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.TelemetryUtils;

public class AppUserTurnstile
extends Event
implements Parcelable {
    private static final String APP_USER_TURNSTILE = "appUserTurnstile";
    private static final String OPERATING_SYSTEM = "Android - " + Build.VERSION.RELEASE;
    private static final String APPLICATION_CONTEXT_CANT_BE_NULL = "Create a MapboxTelemetry instance before calling this method.";
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="userId")
    private final String userId;
    @SerializedName(value="enabled.telemetry")
    private final boolean enabledTelemetry;
    @SerializedName(value="sdkIdentifier")
    private final String sdkIdentifier;
    @SerializedName(value="sdkVersion")
    private final String sdkVersion;
    @SerializedName(value="model")
    private String model = null;
    @SerializedName(value="operatingSystem")
    private String operatingSystem = null;
    public static final Parcelable.Creator<AppUserTurnstile> CREATOR = new Parcelable.Creator<AppUserTurnstile>(){

        public AppUserTurnstile createFromParcel(Parcel in) {
            return new AppUserTurnstile(in);
        }

        public AppUserTurnstile[] newArray(int size) {
            return new AppUserTurnstile[size];
        }
    };

    public AppUserTurnstile(String sdkIdentifier, String sdkVersion) {
        this.checkApplicationContext();
        this.event = APP_USER_TURNSTILE;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.userId = TelemetryUtils.retrieveVendorId();
        TelemetryEnabler telemetryEnabler = new TelemetryEnabler(true);
        this.enabledTelemetry = TelemetryEnabler.TELEMETRY_STATES.get((Object)telemetryEnabler.obtainTelemetryState());
        this.sdkIdentifier = sdkIdentifier;
        this.sdkVersion = sdkVersion;
        this.model = Build.MODEL;
        this.operatingSystem = OPERATING_SYSTEM;
    }

    AppUserTurnstile(String sdkIdentifier, String sdkVersion, boolean isFromPreferences) {
        this.checkApplicationContext();
        this.event = APP_USER_TURNSTILE;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.userId = TelemetryUtils.retrieveVendorId();
        TelemetryEnabler telemetryEnabler = new TelemetryEnabler(isFromPreferences);
        this.enabledTelemetry = TelemetryEnabler.TELEMETRY_STATES.get((Object)telemetryEnabler.obtainTelemetryState());
        this.sdkIdentifier = sdkIdentifier;
        this.sdkVersion = sdkVersion;
        this.model = Build.MODEL;
        this.operatingSystem = OPERATING_SYSTEM;
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.TURNSTILE;
    }

    private AppUserTurnstile(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.userId = in.readString();
        this.enabledTelemetry = in.readByte() != 0;
        this.sdkIdentifier = in.readString();
        this.sdkVersion = in.readString();
        this.model = in.readString();
        this.operatingSystem = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        dest.writeString(this.userId);
        dest.writeByte((byte)(this.enabledTelemetry ? 1 : 0));
        dest.writeString(this.sdkIdentifier);
        dest.writeString(this.sdkVersion);
        dest.writeString(this.model);
        dest.writeString(this.operatingSystem);
    }

    private void checkApplicationContext() {
        if (MapboxTelemetry.applicationContext == null) {
            throw new IllegalStateException(APPLICATION_CONTEXT_CANT_BE_NULL);
        }
    }
}

