/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.JsonAdapter;
import com.mapbox.android.telemetry.CancelDataSerializer;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.NavigationCancelData;
import com.mapbox.android.telemetry.NavigationMetadata;
import com.mapbox.android.telemetry.NavigationMetadataSerializer;
import com.mapbox.android.telemetry.NavigationState;

class NavigationCancelEvent
extends Event
implements Parcelable {
    private static final String NAVIGATION_CANCEL = "navigation.cancel";
    private final String event;
    @JsonAdapter(value=CancelDataSerializer.class)
    private NavigationCancelData cancelData;
    @JsonAdapter(value=NavigationMetadataSerializer.class)
    private NavigationMetadata metadata;
    public static final Parcelable.Creator<NavigationCancelEvent> CREATOR = new Parcelable.Creator<NavigationCancelEvent>(){

        public NavigationCancelEvent createFromParcel(Parcel in) {
            return new NavigationCancelEvent(in);
        }

        public NavigationCancelEvent[] newArray(int size) {
            return new NavigationCancelEvent[size];
        }
    };

    NavigationCancelEvent(NavigationState navigationState) {
        this.event = NAVIGATION_CANCEL;
        this.cancelData = navigationState.getNavigationCancelData();
        this.metadata = navigationState.getNavigationMetadata();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.NAV_CANCEL;
    }

    String getEvent() {
        return this.event;
    }

    NavigationCancelData getCancelData() {
        return this.cancelData;
    }

    NavigationMetadata getMetadata() {
        return this.metadata;
    }

    private NavigationCancelEvent(Parcel in) {
        this.event = in.readString();
        this.cancelData = (NavigationCancelData)in.readParcelable(NavigationCancelData.class.getClassLoader());
        this.metadata = (NavigationMetadata)in.readParcelable(NavigationMetadata.class.getClassLoader());
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeParcelable((Parcelable)this.cancelData, flags);
        dest.writeParcelable((Parcelable)this.metadata, flags);
    }

    public int describeContents() {
        return 0;
    }
}

