/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapState;
import com.mapbox.android.telemetry.TelemetryUtils;

class MapDragendEvent
extends Event
implements Parcelable {
    private static final String MAP_DRAGEND = "map.dragend";
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="lat")
    private double latitude;
    @SerializedName(value="lng")
    private double longitude;
    @SerializedName(value="zoom")
    private double zoom;
    @SerializedName(value="orientation")
    private String orientation = null;
    @SerializedName(value="batteryLevel")
    private Integer batteryLevel = null;
    @SerializedName(value="pluggedIn")
    private Boolean pluggedIn = null;
    @SerializedName(value="carrier")
    private String carrier = null;
    @SerializedName(value="cellularNetworkType")
    private String cellularNetworkType = null;
    @SerializedName(value="wifi")
    private Boolean wifi = null;
    public static final Parcelable.Creator<MapDragendEvent> CREATOR = new Parcelable.Creator<MapDragendEvent>(){

        public MapDragendEvent createFromParcel(Parcel in) {
            return new MapDragendEvent(in);
        }

        public MapDragendEvent[] newArray(int size) {
            return new MapDragendEvent[size];
        }
    };

    MapDragendEvent(MapState mapState) {
        this.event = MAP_DRAGEND;
        this.latitude = mapState.getLatitude();
        this.longitude = mapState.getLongitude();
        this.zoom = mapState.getZoom();
        this.created = TelemetryUtils.obtainCurrentDate();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.MAP_DRAGEND;
    }

    void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    void setBatteryLevel(int batteryLevel) {
        this.batteryLevel = batteryLevel;
    }

    void setPluggedIn(boolean pluggedIn) {
        this.pluggedIn = pluggedIn;
    }

    void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    void setCellularNetworkType(String cellularNetworkType) {
        this.cellularNetworkType = cellularNetworkType;
    }

    void setWifi(boolean wifi) {
        this.wifi = wifi;
    }

    private MapDragendEvent(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.latitude = in.readDouble();
        this.longitude = in.readDouble();
        this.zoom = in.readDouble();
        this.orientation = in.readString();
        this.batteryLevel = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
        byte pluggedInVal = in.readByte();
        this.pluggedIn = pluggedInVal == 2 ? null : Boolean.valueOf(pluggedInVal != 0);
        this.carrier = in.readString();
        this.cellularNetworkType = in.readString();
        byte wifiVal = in.readByte();
        this.wifi = wifiVal == 2 ? null : Boolean.valueOf(wifiVal != 0);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        dest.writeDouble(this.latitude);
        dest.writeDouble(this.longitude);
        dest.writeDouble(this.zoom);
        dest.writeString(this.orientation);
        if (this.batteryLevel == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(this.batteryLevel.intValue());
        }
        if (this.pluggedIn == null) {
            dest.writeByte((byte)2);
        } else {
            dest.writeByte((byte)(this.pluggedIn != false ? 1 : 0));
        }
        dest.writeString(this.carrier);
        dest.writeString(this.cellularNetworkType);
        if (this.wifi == null) {
            dest.writeByte((byte)2);
        } else {
            dest.writeByte((byte)(this.wifi != false ? 1 : 0));
        }
    }
}

