/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.Binder;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineListener;
import com.mapbox.android.core.location.LocationEnginePriority;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.telemetry.LocationReceiver;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionIdentifier;
import com.mapbox.android.telemetry.TelemetryCallback;
import com.mapbox.android.telemetry.TelemetryReceiver;

public class TelemetryService
extends Service
implements TelemetryCallback,
LocationEngineListener {
    private LocationReceiver locationReceiver = null;
    private TelemetryReceiver telemetryReceiver = null;
    private boolean isLocationReceiverRegistered = false;
    private boolean isTelemetryReceiverRegistered = false;
    private LocationEngine locationEngine = null;
    private ServiceTaskCallback serviceTaskCallback = null;
    private LocationEnginePriority locationPriority = LocationEnginePriority.NO_POWER;

    public void onCreate() {
        super.onCreate();
        this.createLocationReceiver();
        this.createTelemetryReceiver();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return 1;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return new TelemetryBinder();
    }

    public void onDestroy() {
        this.unregisterLocationReceiver();
        this.unregisterTelemetryReceiver();
        super.onDestroy();
    }

    public void onTaskRemoved(Intent rootIntent) {
        this.serviceTaskCallback.onTaskRemoved();
        super.onTaskRemoved(rootIntent);
    }

    @Override
    public void onBackground() {
        System.out.println("TelemetryService#onBackground: Shutting down location receiver...");
        this.unregisterLocationReceiver();
    }

    @Override
    public void onForeground() {
        System.out.println("TelemetryService#onForeground: Restarting location receiver...");
        this.registerLocationReceiver();
    }

    public void onConnected() {
        this.locationEngine.requestLocationUpdates();
    }

    public void onLocationChanged(Location location) {
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(LocationReceiver.supplyIntent(location));
    }

    public void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        this.locationReceiver.updateSessionIdentifier(sessionIdentifier);
    }

    public void updateLocationPriority(LocationEnginePriority priority) {
        this.locationPriority = priority;
        if (this.locationEngine != null) {
            this.disconnectLocationEngine();
            this.setupLocationEngine();
            this.activateLocationEngine();
        }
    }

    void injectServiceTask(ServiceTaskCallback callback) {
        this.serviceTaskCallback = callback;
    }

    boolean isLocationReceiverRegistered() {
        return this.isLocationReceiverRegistered;
    }

    boolean isTelemetryReceiverRegistered() {
        return this.isTelemetryReceiverRegistered;
    }

    private void createLocationReceiver() {
        this.locationReceiver = new LocationReceiver();
        this.registerLocationReceiver();
    }

    private void registerLocationReceiver() {
        this.connectLocationEngine();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.locationReceiver, new IntentFilter("com.mapbox.location_receiver"));
        this.isLocationReceiverRegistered = true;
    }

    private void connectLocationEngine() {
        this.obtainLocationEngine();
        this.setupLocationEngine();
        this.activateLocationEngine();
    }

    private void obtainLocationEngine() {
        this.locationEngine = new LocationEngineProvider((Context)this).obtainBestLocationEngineAvailable();
    }

    private void setupLocationEngine() {
        this.locationEngine.setPriority(this.locationPriority);
        this.locationEngine.addLocationEngineListener((LocationEngineListener)this);
    }

    private void activateLocationEngine() {
        this.locationEngine.activate();
    }

    private void createTelemetryReceiver() {
        this.telemetryReceiver = new TelemetryReceiver(this);
        this.registerTelemetryReceiver();
    }

    private void registerTelemetryReceiver() {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.telemetryReceiver, new IntentFilter("com.mapbox.telemetry_receiver"));
        this.isTelemetryReceiverRegistered = true;
    }

    private void unregisterLocationReceiver() {
        this.disconnectLocationEngine();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.locationReceiver);
        this.isLocationReceiverRegistered = false;
    }

    private void disconnectLocationEngine() {
        this.removeLocationUpdates();
        this.deactivateLocationEngine();
    }

    private void removeLocationUpdates() {
        this.locationEngine.removeLocationUpdates();
        this.locationEngine.removeLocationEngineListener((LocationEngineListener)this);
    }

    private void deactivateLocationEngine() {
        this.locationEngine.deactivate();
    }

    private void unregisterTelemetryReceiver() {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.telemetryReceiver);
        this.isTelemetryReceiverRegistered = false;
    }

    class TelemetryBinder
    extends Binder {
        TelemetryBinder() {
        }

        TelemetryService obtainService() {
            return TelemetryService.this;
        }
    }
}

