/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.SchedulerFlusher;

class AlarmSchedulerFlusher
implements SchedulerFlusher {
    private static final int SCHEDULER_FLUSHER_ALARM_ID = 0;
    private static final int NO_FLAGS = 0;
    private final Context context;
    private final AlarmManager manager;
    private final AlarmReceiver receiver;
    private PendingIntent pendingIntent;

    AlarmSchedulerFlusher(Context context, AlarmManager manager, AlarmReceiver receiver) {
        this.context = context;
        this.manager = manager;
        this.receiver = receiver;
    }

    @Override
    public void register() {
        Intent alarmIntent = this.receiver.supplyIntent();
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)alarmIntent, (int)0);
        this.context.registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter("com.mapbox.scheduler_flusher"));
    }

    @Override
    public void schedule(long elapsedRealTime) {
        long firstFlushingInMillis = elapsedRealTime + 180000L;
        this.manager.setInexactRepeating(3, firstFlushingInMillis, 180000L, this.pendingIntent);
    }

    @Override
    public void unregister() {
        this.manager.cancel(this.pendingIntent);
        this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
    }

    PendingIntent obtainPendingIntent() {
        return this.pendingIntent;
    }
}

