/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.location;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.services.android.telemetry.location.AndroidLocationEngineFactory;
import com.mapbox.services.android.telemetry.location.ClasspathChecker;
import com.mapbox.services.android.telemetry.location.GoogleLocationEngineFactory;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineSupplier;
import com.mapbox.services.android.telemetry.location.LostLocationEngineFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocationEngineProvider {
    private Map<LocationEngine.Type, LocationEngine> locationEngineDictionary;
    private static final List<LocationEngine.Type> OPTIONAL_LOCATION_ENGINES = new ArrayList<LocationEngine.Type>(){
        {
            this.add(LocationEngine.Type.GOOGLE_PLAY_SERVICES);
            this.add(LocationEngine.Type.LOST);
        }
    };

    public LocationEngineProvider(Context context) {
        this.initAvailableLocationEngines(context);
    }

    @NonNull
    public LocationEngine obtainBestLocationEngineAvailable() {
        return this.obtainBestLocationEngine();
    }

    @Nullable
    public LocationEngine obtainLocationEngineBy(LocationEngine.Type type) {
        LocationEngine locationEngine = this.locationEngineDictionary.get((Object)type);
        return locationEngine;
    }

    private void initAvailableLocationEngines(Context context) {
        this.locationEngineDictionary = new HashMap<LocationEngine.Type, LocationEngine>();
        Map<LocationEngine.Type, LocationEngineSupplier> locationEnginesDictionary = this.obtainDefaultLocationEnginesDictionary();
        for (Map.Entry<LocationEngine.Type, LocationEngineSupplier> entry : locationEnginesDictionary.entrySet()) {
            LocationEngineSupplier locationEngineSupplier = entry.getValue();
            if (!locationEngineSupplier.hasDependencyOnClasspath()) continue;
            LocationEngine available = locationEngineSupplier.supply(context);
            this.locationEngineDictionary.put(entry.getKey(), available);
        }
    }

    private Map<LocationEngine.Type, LocationEngineSupplier> obtainDefaultLocationEnginesDictionary() {
        ClasspathChecker classpathChecker = new ClasspathChecker();
        HashMap<LocationEngine.Type, LocationEngineSupplier> locationSources = new HashMap<LocationEngine.Type, LocationEngineSupplier>();
        locationSources.put(LocationEngine.Type.GOOGLE_PLAY_SERVICES, new GoogleLocationEngineFactory(classpathChecker));
        locationSources.put(LocationEngine.Type.LOST, new LostLocationEngineFactory(classpathChecker));
        locationSources.put(LocationEngine.Type.ANDROID, new AndroidLocationEngineFactory());
        return locationSources;
    }

    private LocationEngine obtainBestLocationEngine() {
        LocationEngine androidLocationEngine = this.locationEngineDictionary.get((Object)LocationEngine.Type.ANDROID);
        for (LocationEngine.Type type : OPTIONAL_LOCATION_ENGINES) {
            LocationEngine bestLocationEngine = this.locationEngineDictionary.get((Object)type);
            if (bestLocationEngine == null) continue;
            return bestLocationEngine;
        }
        return androidLocationEngine;
    }
}

