/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.location;

import android.location.Location;
import android.support.annotation.IntRange;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class LocationEngine {
    private static final int TWO_MINUTES = 120000;
    protected int priority;
    protected Integer interval = 1000;
    protected Integer fastestInterval = 1000;
    protected Float smallestDisplacement = Float.valueOf(3.0f);
    protected CopyOnWriteArrayList<LocationEngineListener> locationListeners = new CopyOnWriteArrayList();

    public abstract void activate();

    public abstract void deactivate();

    public abstract boolean isConnected();

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public abstract Location getLastLocation();

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public abstract void requestLocationUpdates();

    public abstract void removeLocationUpdates();

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(@IntRange(from=0L, to=3L) int priority) {
        this.priority = priority;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(@Size(min=0L) int interval) {
        this.interval = interval;
    }

    public int getFastestInterval() {
        return this.fastestInterval;
    }

    public void setFastestInterval(@Size(min=0L) int fastestInterval) {
        this.fastestInterval = fastestInterval;
    }

    public float getSmallestDisplacement() {
        return this.smallestDisplacement.floatValue();
    }

    public void setSmallestDisplacement(@Size(min=0L) float smallestDisplacement) {
        this.smallestDisplacement = Float.valueOf(smallestDisplacement);
    }

    public void addLocationEngineListener(LocationEngineListener listener) {
        if (!this.locationListeners.contains(listener)) {
            this.locationListeners.add(listener);
        }
    }

    public boolean removeLocationEngineListener(LocationEngineListener listener) {
        return this.locationListeners.remove(listener);
    }

    protected static boolean isBetterLocation(Location location, Location currentBestLocation) {
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 120000L;
        boolean isSignificantlyOlder = timeDelta < -120000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = LocationEngine.isSameProvider(location.getProvider(), currentBestLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    private static boolean isSameProvider(String provider1, String provider2) {
        if (provider1 == null) {
            return provider2 == null;
        }
        return provider1.equals(provider2);
    }
}

