/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.service;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import com.mapbox.services.android.telemetry.TelemetryLocationReceiver;
import timber.log.Timber;

public class TelemetryService
extends Service {
    private TelemetryLocationReceiver receiver = null;

    @Nullable
    public IBinder onBind(Intent intent) {
        Timber.w((String)"The service doesn't support a binder interface.", (Object[])new Object[0]);
        return null;
    }

    public void onCreate() {
        Timber.v((String)"Create event.", (Object[])new Object[0]);
        this.receiver = new TelemetryLocationReceiver();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter("com.mapbox.services.android.telemetry.location.TelemetryLocationReceiver"));
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Timber.v((String)"Start command event.", (Object[])new Object[0]);
        return 2;
    }

    public void onTaskRemoved(Intent rootIntent) {
        Timber.v((String)"Task removed event.", (Object[])new Object[0]);
        this.shutdownTelemetryService();
    }

    public void onDestroy() {
        Timber.v((String)"Destroy event.", (Object[])new Object[0]);
        this.shutdownTelemetryService();
    }

    private void shutdownTelemetryService() {
        try {
            Timber.v((String)"Unregistering location receiver.", (Object[])new Object[0]);
            LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.receiver);
        }
        catch (Exception exception) {
            Timber.e((String)"Unregistering receiver failed: %s.", (Object[])new Object[]{exception.getMessage()});
        }
    }
}

