/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.http;

import android.text.TextUtils;
import com.mapbox.services.android.telemetry.http.GzipRequestInterceptor;
import com.mapbox.services.android.telemetry.utils.MathUtils;
import java.util.Hashtable;
import java.util.Vector;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

public class TelemetryClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String userAgent = "MapboxEventsAndroid/2.0.0-beta.1";
    private String eventsEndpoint = "https://events.mapbox.com";
    private String accessToken = null;
    private boolean stagingEnvironment = false;
    private OkHttpClient client;

    public TelemetryClient(String accessToken) {
        this.accessToken = accessToken;
        this.client = new OkHttpClient.Builder().certificatePinner(this.buildCertificatePinner()).addInterceptor((Interceptor)new GzipRequestInterceptor()).retryOnConnectionFailure(true).build();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getEventsEndpoint() {
        return this.eventsEndpoint;
    }

    public void setEventsEndpoint(String eventsEndpoint) {
        this.eventsEndpoint = eventsEndpoint;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isStagingEnvironment() {
        return this.stagingEnvironment;
    }

    public void setStagingEnvironment(boolean stagingEnvironment) {
        this.stagingEnvironment = stagingEnvironment;
    }

    private CertificatePinner buildCertificatePinner() {
        CertificatePinner.Builder certificatePinnerBuilder = new CertificatePinner.Builder();
        if (this.isStagingEnvironment()) {
            certificatePinnerBuilder.add("cloudfront-staging.tilestream.net", new String[]{"sha256/3euxrJOrEZI15R4104UsiAkDqe007EPyZ6eTL/XxdAY="}).add("cloudfront-staging.tilestream.net", new String[]{"sha256/5kJvNEMw0KjrCAu7eXY5HZdvyCS13BbA0VJG1RSP91w="}).add("cloudfront-staging.tilestream.net", new String[]{"sha256/r/mIkG3eEpVdm+u/ko/cwxzOMo1bk4TyHIlByibiA5E="});
        } else {
            certificatePinnerBuilder.add("events.mapbox.com", new String[]{"sha256/BhynraKizavqoC5U26qgYuxLZst6pCu9J5stfL6RSYY="}).add("events.mapbox.com", new String[]{"sha256/owrR9U9FWDWtrFF+myoRIu75JwU4sJwzvhCNLZoY37g="}).add("events.mapbox.com", new String[]{"sha256/SQVGZiOrQXi+kqxcvWWE96HhfydlLVqFr4lQTqI5qqo="}).add("events.mapbox.com", new String[]{"sha256/Tb0uHZ/KQjWh8N9+CZFLc4zx36LONQ55l6laDi1qtT4="}).add("events.mapbox.com", new String[]{"sha256/RRM1dGqnDFsCJXBTHky16vi1obOlCgFFn/yOhI/y+ho="}).add("events.mapbox.com", new String[]{"sha256/WoiWRyIOVNa9ihaBciRSC7XHjliYS9VwUGOIud4PB18="});
        }
        return certificatePinnerBuilder.build();
    }

    public void sendEvents(Vector<Hashtable<String, Object>> events, Callback callback) {
        if (events == null || events.size() == 0) {
            Timber.v((String)"Returning, no event data to send.", (Object[])new Object[0]);
            return;
        }
        try {
            this.sendEventsWrapped(events, callback);
        }
        catch (Exception exception) {
            Timber.e((String)"Request preparation failed: %s.", (Object[])new Object[]{exception.getMessage()});
        }
    }

    private void sendEventsWrapped(Vector<Hashtable<String, Object>> events, Callback callback) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (Hashtable<String, Object> evt : events) {
            String eventType;
            String appState;
            String carrier;
            String orientation;
            JSONObject jsonObject = new JSONObject();
            jsonObject.putOpt("event", evt.get("event"));
            jsonObject.putOpt("created", evt.get("created"));
            jsonObject.putOpt("userId", evt.get("userId"));
            jsonObject.putOpt("enabled.telemetry", evt.get("enabled.telemetry"));
            jsonObject.putOpt("source", evt.get("source"));
            jsonObject.putOpt("sessionId", evt.get("sessionId"));
            jsonObject.putOpt("lat", evt.get("lat"));
            if (evt.containsKey("lng")) {
                double lon = (Double)evt.get("lng");
                if (lon < -180.0 || lon > 180.0) {
                    lon = MathUtils.wrap(lon, -180.0, 180.0);
                }
                jsonObject.put("lng", lon);
            }
            jsonObject.putOpt("altitude", evt.get("altitude"));
            jsonObject.putOpt("zoom", evt.get("zoom"));
            jsonObject.putOpt("operatingSystem", evt.get("operatingSystem"));
            jsonObject.putOpt("userId", evt.get("userId"));
            jsonObject.putOpt("model", evt.get("model"));
            jsonObject.putOpt("resolution", evt.get("resolution"));
            jsonObject.putOpt("accessibilityFontScale", evt.get("accessibilityFontScale"));
            jsonObject.putOpt("batteryLevel", evt.get("batteryLevel"));
            jsonObject.putOpt("pluggedIn", evt.get("pluggedIn"));
            jsonObject.putOpt("wifi", evt.get("wifi"));
            if (evt.containsKey("orientation") && !TextUtils.isEmpty((CharSequence)(orientation = (String)evt.get("orientation")))) {
                jsonObject.putOpt("orientation", (Object)orientation);
            }
            if (evt.containsKey("carrier") && !TextUtils.isEmpty((CharSequence)(carrier = (String)evt.get("carrier")))) {
                jsonObject.putOpt("carrier", (Object)carrier);
            }
            if (evt.containsKey("applicationState") && !TextUtils.isEmpty((CharSequence)(appState = (String)evt.get("applicationState")))) {
                jsonObject.putOpt("applicationState", evt.get("applicationState"));
            }
            if (!TextUtils.isEmpty((CharSequence)(eventType = (String)evt.get("event"))) && eventType.equalsIgnoreCase("map.click")) {
                jsonObject.put("gesture", evt.get("gesture"));
            }
            if (evt.containsKey("cellularNetworkType")) {
                String cellularNetworkType = (String)evt.get("cellularNetworkType");
                if (TextUtils.isEmpty((CharSequence)cellularNetworkType)) {
                    jsonObject.put("cellularNetworkType", null);
                } else {
                    jsonObject.put("cellularNetworkType", evt.get("cellularNetworkType"));
                }
            }
            jsonArray.put((Object)jsonObject);
        }
        String payload = jsonArray.toString();
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
        String url = this.eventsEndpoint + "/events/v2?access_token=" + this.accessToken;
        if (this.isStagingEnvironment()) {
            Timber.d((String)"Sending POST to %s with %d event(s) (user agent: %s) with payload: %s", (Object[])new Object[]{url, events.size(), this.userAgent, payload});
        }
        Request request = new Request.Builder().url(url).header("User-Agent", this.userAgent).post(body).build();
        this.client.newCall(request).enqueue(callback);
    }
}

