/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.text;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;

@Keep
public class LocalGlyphRasterizer {
    private final Bitmap bitmap = Bitmap.createBitmap((int)35, (int)35, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    @NonNull
    private final Paint paint = new Paint();
    @NonNull
    private final Canvas canvas;

    LocalGlyphRasterizer() {
        this.paint.setAntiAlias(true);
        this.paint.setTextSize(24.0f);
        this.canvas = new Canvas();
        this.canvas.setBitmap(this.bitmap);
    }

    @WorkerThread
    protected Bitmap drawGlyphBitmap(String fontFamily, boolean bold, char glyphID) {
        this.paint.setTypeface(Typeface.create((String)fontFamily, (int)(bold ? 1 : 0)));
        this.canvas.drawColor(-1);
        this.canvas.drawText(String.valueOf(glyphID), 0.0f, 20.0f, this.paint);
        return this.bitmap;
    }
}

