/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Environment;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.utils.FileUtils;
import com.mapbox.mapboxsdk.utils.ThreadUtils;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FileSource {
    private static final String TAG = "Mbgl-FileSource";
    private static final String MAPBOX_SHARED_PREFERENCE_RESOURCES_CACHE_PATH = "fileSourceResourcesCachePath";
    private static final Lock resourcesCachePathLoaderLock = new ReentrantLock();
    private static final Lock internalCachePathLoaderLock = new ReentrantLock();
    @Nullable
    private static String resourcesCachePath;
    private static String internalCachePath;
    private static FileSource INSTANCE;
    @Keep
    private long nativePtr;

    @UiThread
    public static synchronized FileSource getInstance(@NonNull Context context) {
        if (INSTANCE == null) {
            INSTANCE = new FileSource(FileSource.getResourcesCachePath(context));
        }
        return INSTANCE;
    }

    @NonNull
    private static String getCachePath(@NonNull Context context) {
        SharedPreferences preferences = context.getSharedPreferences("MapboxSharedPreferences", 0);
        String cachePath = preferences.getString(MAPBOX_SHARED_PREFERENCE_RESOURCES_CACHE_PATH, null);
        if (!FileSource.isPathWritable(cachePath)) {
            cachePath = FileSource.getDefaultCachePath(context);
            SharedPreferences.Editor editor = context.getSharedPreferences("MapboxSharedPreferences", 0).edit();
            editor.remove(MAPBOX_SHARED_PREFERENCE_RESOURCES_CACHE_PATH).apply();
        }
        return cachePath;
    }

    @NonNull
    private static String getDefaultCachePath(@NonNull Context context) {
        File externalFilesDir;
        if (FileSource.isExternalStorageConfiguration(context) && FileSource.isExternalStorageReadable() && (externalFilesDir = context.getExternalFilesDir(null)) != null) {
            return externalFilesDir.getAbsolutePath();
        }
        return context.getFilesDir().getAbsolutePath();
    }

    private static boolean isExternalStorageConfiguration(@NonNull Context context) {
        boolean isExternalStorageConfiguration = false;
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData != null) {
                isExternalStorageConfiguration = appInfo.metaData.getBoolean("com.mapbox.SetStorageExternal", false);
            }
        }
        catch (PackageManager.NameNotFoundException exception) {
            Logger.e(TAG, "Failed to read the package metadata: ", exception);
            MapStrictMode.strictModeViolation(exception);
        }
        catch (Exception exception) {
            Logger.e(TAG, "Failed to read the storage key: ", exception);
            MapStrictMode.strictModeViolation(exception);
        }
        return isExternalStorageConfiguration;
    }

    public static boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state) || "mounted_ro".equals(state)) {
            return true;
        }
        Logger.w(TAG, "External storage was requested but it isn't readable. For API level < 18 make sure you've requested READ_EXTERNAL_STORAGE or WRITE_EXTERNAL_STORAGE permissions in your app Manifest (defaulting to internal storage).");
        return false;
    }

    @UiThread
    public static void initializeFileDirsPaths(Context context) {
        ThreadUtils.checkThread(TAG);
        FileSource.lockPathLoaders();
        if (resourcesCachePath == null || internalCachePath == null) {
            new FileDirsPathsTask().execute(new Context[]{context});
        }
    }

    @NonNull
    public static String getResourcesCachePath(@NonNull Context context) {
        resourcesCachePathLoaderLock.lock();
        try {
            if (resourcesCachePath == null) {
                resourcesCachePath = FileSource.getCachePath(context);
            }
            String string2 = resourcesCachePath;
            return string2;
        }
        finally {
            resourcesCachePathLoaderLock.unlock();
        }
    }

    public static String getInternalCachePath(@NonNull Context context) {
        internalCachePathLoaderLock.lock();
        try {
            if (internalCachePath == null) {
                internalCachePath = context.getCacheDir().getAbsolutePath();
            }
            String string2 = internalCachePath;
            return string2;
        }
        finally {
            internalCachePathLoaderLock.unlock();
        }
    }

    @Deprecated
    public static void setResourcesCachePath(@NonNull Context context, @NonNull String path, @NonNull ResourcesCachePathChangeCallback callback) {
        FileSource.setResourcesCachePath(path, callback);
    }

    public static void setResourcesCachePath(final @NonNull String path, final @NonNull ResourcesCachePathChangeCallback callback) {
        final Context applicationContext = Mapbox.getApplicationContext();
        FileSource fileSource = FileSource.getInstance(applicationContext);
        if (fileSource.isActivated()) {
            String fileSourceActivatedMessage = "Cannot set path, file source is activated. Make sure that the map or a resources download is not running.";
            Logger.w(TAG, fileSourceActivatedMessage);
            callback.onError(fileSourceActivatedMessage);
        } else if (path.equals(FileSource.getResourcesCachePath(applicationContext))) {
            callback.onSuccess(path);
        } else {
            new FileUtils.CheckFileWritePermissionTask(new FileUtils.OnCheckFileWritePermissionListener(){

                @Override
                public void onWritePermissionGranted() {
                    SharedPreferences.Editor editor = applicationContext.getSharedPreferences("MapboxSharedPreferences", 0).edit();
                    editor.putString(FileSource.MAPBOX_SHARED_PREFERENCE_RESOURCES_CACHE_PATH, path);
                    editor.apply();
                    FileSource.internalSetResourcesCachePath(applicationContext, path, callback);
                }

                @Override
                public void onError() {
                    String message = "Path is not writable: " + path;
                    Logger.e(FileSource.TAG, message);
                    callback.onError(message);
                }
            }).execute(new File[]{new File(path)});
        }
    }

    private static void internalSetResourcesCachePath(@NonNull Context context, @NonNull String path, final @NonNull ResourcesCachePathChangeCallback callback) {
        final FileSource fileSource = FileSource.getInstance(context);
        fileSource.setResourceCachePath(path, new ResourcesCachePathChangeCallback(){

            @Override
            public void onSuccess(@NonNull String path) {
                fileSource.deactivate();
                resourcesCachePathLoaderLock.lock();
                resourcesCachePath = path;
                resourcesCachePathLoaderLock.unlock();
                callback.onSuccess(path);
            }

            @Override
            public void onError(@NonNull String message) {
                fileSource.deactivate();
                callback.onError(message);
            }
        });
        fileSource.activate();
    }

    private static boolean isPathWritable(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        return new File(path).canWrite();
    }

    private static void lockPathLoaders() {
        internalCachePathLoaderLock.lock();
        resourcesCachePathLoaderLock.lock();
    }

    private static void unlockPathLoaders() {
        resourcesCachePathLoaderLock.unlock();
        internalCachePathLoaderLock.unlock();
    }

    private FileSource(String cachePath) {
        this.initialize(Mapbox.getAccessToken(), cachePath);
    }

    @Keep
    public native boolean isActivated();

    @Keep
    public native void activate();

    @Keep
    public native void deactivate();

    @Keep
    public native void setAccessToken(String var1);

    @NonNull
    @Keep
    public native String getAccessToken();

    @Keep
    public native void setApiBaseUrl(String var1);

    @Keep
    public native void setResourceTransform(ResourceTransformCallback var1);

    @Keep
    private native void setResourceCachePath(String var1, ResourcesCachePathChangeCallback var2);

    @Keep
    private native void initialize(String var1, String var2);

    @Keep
    protected native void finalize() throws Throwable;

    private static class FileDirsPathsTask
    extends AsyncTask<Context, Void, String[]> {
        private FileDirsPathsTask() {
        }

        protected void onCancelled() {
            FileSource.unlockPathLoaders();
        }

        @NonNull
        protected String[] doInBackground(Context ... contexts) {
            return new String[]{FileSource.getCachePath(contexts[0]), contexts[0].getCacheDir().getAbsolutePath()};
        }

        protected void onPostExecute(String[] paths) {
            resourcesCachePath = paths[0];
            internalCachePath = paths[1];
            FileSource.unlockPathLoaders();
        }
    }

    @Keep
    public static interface ResourcesCachePathChangeCallback {
        public void onSuccess(@NonNull String var1);

        public void onError(@NonNull String var1);
    }

    @Keep
    public static interface ResourceTransformCallback {
        public String onURL(int var1, String var2);
    }
}

