/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.snapshotter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.os.Handler;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.core.content.res.ResourcesCompat;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.attribution.AttributionLayout;
import com.mapbox.mapboxsdk.attribution.AttributionMeasure;
import com.mapbox.mapboxsdk.attribution.AttributionParser;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.snapshotter.MapSnapshot;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.FontUtils;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

@UiThread
public class MapSnapshotter {
    private static final String TAG = "Mbgl-MapSnapshotter";
    private static final int LOGO_MARGIN_DP = 4;
    @Keep
    private long nativePtr = 0L;
    private final Context context;
    private boolean fullyLoaded = false;
    private Options options;
    @Nullable
    private SnapshotReadyCallback callback;
    @Nullable
    private ErrorHandler errorHandler;
    @Nullable
    private Observer observer;

    public MapSnapshotter(@NonNull Context context, @NonNull Options options) {
        this.checkThread();
        this.context = context.getApplicationContext();
        this.options = options;
        TelemetryDefinition telemetry = Mapbox.getTelemetry();
        if (telemetry != null) {
            telemetry.onAppUserTurnstileEvent();
        }
        FileSource fileSource = FileSource.getInstance(context);
        String apiBaseUrl = options.getApiBaseUrl();
        if (!TextUtils.isEmpty((CharSequence)apiBaseUrl)) {
            fileSource.setApiBaseUrl(apiBaseUrl);
        }
        this.nativeInitialize(this, fileSource, options.pixelRatio, options.width, options.height, options.getStyleUri(), options.getStyleJson(), options.region, options.cameraPosition, options.showLogo, options.localIdeographFontFamily);
    }

    public void start(@NonNull SnapshotReadyCallback callback) {
        this.start(callback, null);
    }

    public void start(@NonNull SnapshotReadyCallback callback, ErrorHandler errorHandler) {
        if (this.callback != null) {
            throw new IllegalStateException("Snapshotter was already started");
        }
        this.checkThread();
        this.callback = callback;
        this.errorHandler = errorHandler;
        this.nativeStart();
    }

    @Keep
    public native void setSize(int var1, int var2);

    @Keep
    public native void setCameraPosition(CameraPosition var1);

    @Keep
    public native void setRegion(LatLngBounds var1);

    @Keep
    public native void setStyleUrl(String var1);

    @Keep
    public native void setStyleJson(String var1);

    private void addLayerBelow(Layer layer, String below) {
        this.nativeAddLayerBelow(layer.getNativePtr(), below);
    }

    private void addLayerAbove(@NonNull Layer layer, @NonNull String above) {
        this.nativeAddLayerAbove(layer.getNativePtr(), above);
    }

    private void addLayerAt(Layer layer, int index) {
        this.nativeAddLayerAt(layer.getNativePtr(), index);
    }

    private void addSource(Source source) {
        this.nativeAddSource(source, source.getNativePtr());
    }

    public void addImage(@NonNull String name, @NonNull Bitmap bitmap, boolean sdf) {
        this.nativeAddImages(new Image[]{Style.toImage(new Style.Builder.ImageWrapper(name, bitmap, sdf))});
    }

    public void cancel() {
        this.checkThread();
        this.reset();
        this.nativeCancel();
    }

    public void setObserver(@Nullable Observer observer) {
        this.checkThread();
        this.observer = observer;
    }

    protected void addOverlay(@NonNull MapSnapshot mapSnapshot) {
        Bitmap snapshot = mapSnapshot.getBitmap();
        Canvas canvas = new Canvas(snapshot);
        int margin = (int)this.context.getResources().getDisplayMetrics().density * 4;
        this.drawOverlay(mapSnapshot, snapshot, canvas, margin);
    }

    private void drawOverlay(@NonNull MapSnapshot mapSnapshot, @NonNull Bitmap snapshot, @NonNull Canvas canvas, int margin) {
        AttributionMeasure measure = this.getAttributionMeasure(mapSnapshot, snapshot, margin);
        AttributionLayout layout2 = measure.measure();
        this.drawLogo(mapSnapshot, canvas, margin, layout2);
        this.drawAttribution(mapSnapshot, canvas, measure, layout2);
    }

    @NonNull
    private AttributionMeasure getAttributionMeasure(@NonNull MapSnapshot mapSnapshot, @NonNull Bitmap snapshot, int margin) {
        Logo logo = this.createScaledLogo(snapshot);
        TextView longText = this.createTextView(mapSnapshot, false, logo.getScale());
        TextView shortText = this.createTextView(mapSnapshot, true, logo.getScale());
        return new AttributionMeasure.Builder().setSnapshot(snapshot).setLogo(logo.getLarge()).setLogoSmall(logo.getSmall()).setTextView(longText).setTextViewShort(shortText).setMarginPadding(margin).build();
    }

    private void drawLogo(MapSnapshot mapSnapshot, @NonNull Canvas canvas, int margin, @NonNull AttributionLayout layout2) {
        if (mapSnapshot.isShowLogo()) {
            this.drawLogo(mapSnapshot.getBitmap(), canvas, margin, layout2);
        }
    }

    private void drawLogo(@NonNull Bitmap snapshot, @NonNull Canvas canvas, int margin, AttributionLayout placement) {
        Bitmap selectedLogo = placement.getLogo();
        if (selectedLogo != null) {
            canvas.drawBitmap(selectedLogo, (float)margin, (float)(snapshot.getHeight() - selectedLogo.getHeight() - margin), null);
        }
    }

    private void drawAttribution(@NonNull MapSnapshot mapSnapshot, @NonNull Canvas canvas, @NonNull AttributionMeasure measure, AttributionLayout layout2) {
        PointF anchorPoint = layout2.getAnchorPoint();
        if (anchorPoint != null) {
            this.drawAttribution(canvas, measure, anchorPoint);
        } else {
            Bitmap snapshot = mapSnapshot.getBitmap();
            Logger.e(TAG, String.format("Could not generate attribution for snapshot size: %s x %s. You are required to provide your own attribution for the used sources: %s", snapshot.getWidth(), snapshot.getHeight(), mapSnapshot.getAttributions()));
        }
    }

    private void drawAttribution(Canvas canvas, AttributionMeasure measure, PointF anchorPoint) {
        canvas.save();
        canvas.translate(anchorPoint.x, anchorPoint.y);
        measure.getTextView().draw(canvas);
        canvas.restore();
    }

    @NonNull
    private TextView createTextView(@NonNull MapSnapshot mapSnapshot, boolean shortText, float scale) {
        int textColor = ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.mapbox_gray_dark, (Resources.Theme)this.context.getTheme());
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        TextView textView = new TextView(this.context);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        textView.setSingleLine(true);
        textView.setTextSize(10.0f * scale);
        textView.setTextColor(textColor);
        textView.setBackgroundResource(R.drawable.mapbox_rounded_corner);
        textView.setText((CharSequence)Html.fromHtml((String)this.createAttributionString(mapSnapshot, shortText)));
        textView.measure(widthMeasureSpec, heightMeasureSpec);
        textView.layout(0, 0, textView.getMeasuredWidth(), textView.getMeasuredHeight());
        return textView;
    }

    @NonNull
    private String createAttributionString(MapSnapshot mapSnapshot, boolean shortText) {
        AttributionParser attributionParser = new AttributionParser.Options(this.context).withAttributionData(mapSnapshot.getAttributions()).withCopyrightSign(false).withImproveMap(false).build();
        return attributionParser.createAttributionString(shortText);
    }

    private Logo createScaledLogo(@NonNull Bitmap snapshot) {
        Bitmap logo = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.mapbox_logo_icon, null);
        float scale = this.calculateLogoScale(snapshot, logo);
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap helmet = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.mapbox_logo_helmet, null);
        Bitmap large = Bitmap.createBitmap((Bitmap)logo, (int)0, (int)0, (int)logo.getWidth(), (int)logo.getHeight(), (Matrix)matrix, (boolean)true);
        Bitmap small = Bitmap.createBitmap((Bitmap)helmet, (int)0, (int)0, (int)helmet.getWidth(), (int)helmet.getHeight(), (Matrix)matrix, (boolean)true);
        return new Logo(large, small, scale);
    }

    private float calculateLogoScale(Bitmap snapshot, Bitmap logo) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        float widthRatio = displayMetrics.widthPixels / snapshot.getWidth();
        float heightRatio = displayMetrics.heightPixels / snapshot.getHeight();
        float prefWidth = (float)logo.getWidth() / widthRatio;
        float prefHeight = (float)logo.getHeight() / heightRatio;
        float calculatedScale = Math.min(prefWidth / (float)logo.getWidth(), prefHeight / (float)logo.getHeight()) * 2.0f;
        if (calculatedScale > 1.0f) {
            calculatedScale = 1.0f;
        } else if (calculatedScale < 0.6f) {
            calculatedScale = 0.6f;
        }
        return calculatedScale;
    }

    @Keep
    protected void onSnapshotReady(final @NonNull MapSnapshot snapshot) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (MapSnapshotter.this.callback != null) {
                    MapSnapshotter.this.addOverlay(snapshot);
                    MapSnapshotter.this.callback.onSnapshotReady(snapshot);
                    MapSnapshotter.this.reset();
                }
            }
        });
    }

    @Keep
    protected void onSnapshotFailed(final String reason) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (MapSnapshotter.this.errorHandler != null) {
                    MapSnapshotter.this.errorHandler.onError(reason);
                    MapSnapshotter.this.reset();
                }
            }
        });
    }

    @Keep
    protected void onDidFailLoadingStyle(String reason) {
        this.onSnapshotFailed(reason);
    }

    @Keep
    protected void onDidFinishLoadingStyle() {
        if (!this.fullyLoaded) {
            this.fullyLoaded = true;
            Style.Builder builder = this.options.getBuilder();
            if (builder != null) {
                for (Source source : builder.getSources()) {
                    this.nativeAddSource(source, source.getNativePtr());
                }
                for (Style.Builder.LayerWrapper layerWrapper : builder.getLayers()) {
                    if (layerWrapper instanceof Style.Builder.LayerAtWrapper) {
                        this.addLayerAt(layerWrapper.getLayer(), ((Style.Builder.LayerAtWrapper)layerWrapper).getIndex());
                        continue;
                    }
                    if (layerWrapper instanceof Style.Builder.LayerAboveWrapper) {
                        this.addLayerAbove(layerWrapper.getLayer(), ((Style.Builder.LayerAboveWrapper)layerWrapper).getAboveLayer());
                        continue;
                    }
                    if (layerWrapper instanceof Style.Builder.LayerBelowWrapper) {
                        this.addLayerBelow(layerWrapper.getLayer(), ((Style.Builder.LayerBelowWrapper)layerWrapper).getBelowLayer());
                        continue;
                    }
                    this.addLayerBelow(layerWrapper.getLayer(), "com.mapbox.annotations.points");
                }
                for (Style.Builder.ImageWrapper image : builder.getImages()) {
                    this.addImage(image.getId(), image.getBitmap(), image.isSdf());
                }
            }
        }
        if (this.observer != null) {
            this.observer.onDidFinishLoadingStyle();
        }
    }

    @Nullable
    public Layer getLayer(@NonNull String layerId) {
        this.checkThread();
        return this.fullyLoaded ? this.nativeGetLayer(layerId) : null;
    }

    @Nullable
    public Source getSource(@NonNull String sourceId) {
        this.checkThread();
        return this.fullyLoaded ? this.nativeGetSource(sourceId) : null;
    }

    @Keep
    protected void onStyleImageMissing(String imageName) {
        if (this.observer != null) {
            this.observer.onStyleImageMissing(imageName);
        }
    }

    private void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    protected void reset() {
        this.callback = null;
        this.errorHandler = null;
    }

    @Keep
    protected native void nativeInitialize(MapSnapshotter var1, FileSource var2, float var3, int var4, int var5, String var6, String var7, LatLngBounds var8, CameraPosition var9, boolean var10, String var11);

    @Keep
    protected native void nativeStart();

    @Keep
    protected native void nativeCancel();

    @Keep
    private native void nativeAddLayerBelow(long var1, String var3);

    @Keep
    private native void nativeAddLayerAbove(long var1, String var3);

    @Keep
    private native void nativeAddLayerAt(long var1, int var3);

    @Keep
    private native void nativeAddSource(Source var1, long var2);

    @Keep
    private native void nativeAddImages(Image[] var1);

    @NonNull
    @Keep
    private native Layer nativeGetLayer(String var1);

    @NonNull
    @Keep
    private native Source nativeGetSource(String var1);

    @Keep
    protected native void finalize() throws Throwable;

    private class Logo {
        private Bitmap large;
        private Bitmap small;
        private float scale;

        Logo(Bitmap large, Bitmap small, float scale) {
            this.large = large;
            this.small = small;
            this.scale = scale;
        }

        public Bitmap getLarge() {
            return this.large;
        }

        public Bitmap getSmall() {
            return this.small;
        }

        public float getScale() {
            return this.scale;
        }
    }

    public static class Options {
        private float pixelRatio = 1.0f;
        private int width;
        private int height;
        private LatLngBounds region;
        private CameraPosition cameraPosition;
        private boolean showLogo = true;
        private String localIdeographFontFamily = "sans-serif";
        private String apiBaseUrl;
        private Style.Builder builder;

        public Options(int width, int height) {
            if (width == 0 || height == 0) {
                throw new IllegalArgumentException("Unable to create a snapshot with width or height set to 0");
            }
            this.width = width;
            this.height = height;
        }

        @NonNull
        public Options withStyleBuilder(Style.Builder builder) {
            this.builder = builder;
            return this;
        }

        public Style.Builder getBuilder() {
            return this.builder;
        }

        @NonNull
        public Options withStyle(String uri) {
            this.withStyleBuilder(new Style.Builder().fromUri(uri));
            return this;
        }

        @NonNull
        public Options withStyleJson(String styleJson) {
            this.withStyleBuilder(new Style.Builder().fromJson(styleJson));
            return this;
        }

        @NonNull
        public Options withRegion(LatLngBounds region) {
            this.region = region;
            return this;
        }

        @NonNull
        public Options withPixelRatio(float pixelRatio) {
            this.pixelRatio = pixelRatio;
            return this;
        }

        @NonNull
        public Options withCameraPosition(CameraPosition cameraPosition) {
            this.cameraPosition = cameraPosition;
            return this;
        }

        @NonNull
        public Options withLogo(boolean showLogo) {
            this.showLogo = showLogo;
            return this;
        }

        @NonNull
        public Options withLocalIdeographFontFamily(String fontFamily) {
            this.localIdeographFontFamily = FontUtils.extractValidFont(fontFamily);
            return this;
        }

        @NonNull
        public Options withLocalIdeographFontFamily(String ... fontFamilies) {
            this.localIdeographFontFamily = FontUtils.extractValidFont(fontFamilies);
            return this;
        }

        @Deprecated
        @NonNull
        public Options withApiBaseUrl(String apiBaseUrl) {
            this.apiBaseUrl = apiBaseUrl;
            return this;
        }

        @NonNull
        public Options withApiBaseUri(String apiBaseUri) {
            this.apiBaseUrl = apiBaseUri;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public float getPixelRatio() {
            return this.pixelRatio;
        }

        @Nullable
        public LatLngBounds getRegion() {
            return this.region;
        }

        @Deprecated
        public String getStyleUrl() {
            return this.builder == null ? "mapbox://styles/mapbox/streets-v11" : this.builder.getUri();
        }

        public String getStyleUri() {
            return this.builder == null ? "mapbox://styles/mapbox/streets-v11" : this.builder.getUri();
        }

        @Nullable
        public String getStyleJson() {
            return this.builder == null ? null : this.builder.getJson();
        }

        @Nullable
        public CameraPosition getCameraPosition() {
            return this.cameraPosition;
        }

        public String getLocalIdeographFontFamily() {
            return this.localIdeographFontFamily;
        }

        @Deprecated
        @Nullable
        public String getApiBaseUrl() {
            return this.apiBaseUrl;
        }

        @Nullable
        public String getApiBaseUri() {
            return this.apiBaseUrl;
        }
    }

    public static interface Observer {
        public void onDidFinishLoadingStyle();

        public void onStyleImageMissing(String var1);
    }

    public static interface ErrorHandler {
        public void onError(String var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(MapSnapshot var1);
    }
}

