/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import androidx.annotation.Keep;

public class OfflineRegionStatus {
    private int downloadState;
    private final long completedResourceCount;
    private final long completedResourceSize;
    private final long completedTileCount;
    private final long completedTileSize;
    private final long requiredResourceCount;
    private final boolean requiredResourceCountIsPrecise;

    @Keep
    private OfflineRegionStatus(int downloadState, long completedResourceCount, long completedResourceSize, long completedTileCount, long completedTileSize, long requiredResourceCount, boolean requiredResourceCountIsPrecise) {
        this.downloadState = downloadState;
        this.completedResourceCount = completedResourceCount;
        this.completedResourceSize = completedResourceSize;
        this.completedTileCount = completedTileCount;
        this.completedTileSize = completedTileSize;
        this.requiredResourceCount = requiredResourceCount;
        this.requiredResourceCountIsPrecise = requiredResourceCountIsPrecise;
    }

    public boolean isComplete() {
        return this.completedResourceCount >= this.requiredResourceCount;
    }

    public int getDownloadState() {
        return this.downloadState;
    }

    public long getCompletedResourceCount() {
        return this.completedResourceCount;
    }

    public long getCompletedResourceSize() {
        return this.completedResourceSize;
    }

    public long getCompletedTileCount() {
        return this.completedTileCount;
    }

    public long getCompletedTileSize() {
        return this.completedTileSize;
    }

    public long getRequiredResourceCount() {
        return this.requiredResourceCount;
    }

    public boolean isRequiredResourceCountPrecise() {
        return this.requiredResourceCountIsPrecise;
    }
}

