/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.mapbox.android.telemetry.TelemetryUtils;

class PhoneState {
    private static final String NO_CARRIER = "EMPTY_CARRIER";
    private static final int NO_NETWORK = -1;
    private String created;
    private String cellularNetworkType;
    private Orientation orientation;
    private String carrier;
    private int batteryLevel;
    private boolean pluggedIn;
    private boolean wifi;
    private float accessibilityFontScale;
    private float resolution;

    PhoneState() {
    }

    PhoneState(@NonNull Context context) {
        this.created = TelemetryUtils.obtainCurrentDate();
        this.batteryLevel = TelemetryUtils.obtainBatteryLevel((Context)context);
        this.pluggedIn = TelemetryUtils.isPluggedIn((Context)context);
        this.cellularNetworkType = TelemetryUtils.obtainCellularNetworkType((Context)context);
        this.orientation = Orientation.getOrientation(context.getResources().getConfiguration().orientation);
        this.accessibilityFontScale = context.getResources().getConfiguration().fontScale;
        this.carrier = this.obtainCellularCarrier(context);
        this.resolution = this.obtainDisplayDensity(context);
        this.wifi = this.isConnectedToWifi(context);
    }

    private String obtainCellularCarrier(@NonNull Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        if (manager == null) {
            return NO_CARRIER;
        }
        String carrierName = manager.getNetworkOperatorName();
        if (TextUtils.isEmpty((CharSequence)carrierName)) {
            return NO_CARRIER;
        }
        return carrierName;
    }

    private float obtainDisplayDensity(@NonNull Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.density;
    }

    private boolean isConnectedToWifi(@NonNull Context context) {
        try {
            WifiManager wifiMgr = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (wifiMgr == null) {
                return false;
            }
            WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
            return wifiMgr.isWifiEnabled() && wifiInfo.getNetworkId() != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    String getCreated() {
        return this.created;
    }

    void setCreated(String created) {
        this.created = created;
    }

    int getBatteryLevel() {
        return this.batteryLevel;
    }

    void setBatteryLevel(int batteryLevel) {
        this.batteryLevel = batteryLevel;
    }

    boolean isPluggedIn() {
        return this.pluggedIn;
    }

    void setPluggedIn(boolean pluggedIn) {
        this.pluggedIn = pluggedIn;
    }

    String getCellularNetworkType() {
        return this.cellularNetworkType;
    }

    void setCellularNetworkType(String cellularNetworkType) {
        this.cellularNetworkType = cellularNetworkType;
    }

    String getOrientation() {
        return this.orientation.getOrientation();
    }

    void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    String getCarrier() {
        return this.carrier;
    }

    void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    boolean isWifi() {
        return this.wifi;
    }

    void setWifi(boolean wifi) {
        this.wifi = wifi;
    }

    float getAccessibilityFontScale() {
        return this.accessibilityFontScale;
    }

    void setAccessibilityFontScale(float accessibilityFontScale) {
        this.accessibilityFontScale = accessibilityFontScale;
    }

    float getResolution() {
        return this.resolution;
    }

    void setResolution(float resolution) {
        this.resolution = resolution;
    }

    static enum Orientation {
        ORIENTATION_PORTRAIT("Portrait"),
        ORIENTATION_LANDSCAPE("Landscape");

        private String orientation;

        private Orientation(String orientation) {
            this.orientation = orientation;
        }

        public static Orientation getOrientation(int index) {
            if (1 == index) {
                return ORIENTATION_PORTRAIT;
            }
            return ORIENTATION_LANDSCAPE;
        }

        public String getOrientation() {
            return this.orientation;
        }
    }
}

