/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.FloatRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.geojson.Point;
import com.mapbox.turf.TurfMeasurement;

public class LatLng
implements Parcelable {
    public static final Parcelable.Creator<LatLng> CREATOR = new Parcelable.Creator<LatLng>(){

        public LatLng createFromParcel(@NonNull Parcel in) {
            return new LatLng(in);
        }

        public LatLng[] newArray(int size) {
            return new LatLng[size];
        }
    };
    @Keep
    private double latitude;
    @Keep
    private double longitude;
    private double altitude = 0.0;

    public LatLng() {
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    @Keep
    public LatLng(double latitude, double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public LatLng(double latitude, double longitude, double altitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.setAltitude(altitude);
    }

    public LatLng(Location location) {
        this(location.getLatitude(), location.getLongitude(), location.getAltitude());
    }

    public LatLng(LatLng latLng) {
        this.latitude = latLng.latitude;
        this.longitude = latLng.longitude;
        this.altitude = latLng.altitude;
    }

    protected LatLng(Parcel in) {
        this.setLatitude(in.readDouble());
        this.setLongitude(in.readDouble());
        this.setAltitude(in.readDouble());
    }

    public void setLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        if (Double.isNaN(latitude)) {
            throw new IllegalArgumentException("latitude must not be NaN");
        }
        if (Math.abs(latitude) > 90.0) {
            throw new IllegalArgumentException("latitude must be between -90 and 90");
        }
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(@FloatRange(from=-1.7976931348623157E308, to=1.7976931348623157E308) double longitude) {
        if (Double.isNaN(longitude)) {
            throw new IllegalArgumentException("longitude must not be NaN");
        }
        if (Double.isInfinite(longitude)) {
            throw new IllegalArgumentException("longitude must not be infinite");
        }
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    @NonNull
    public LatLng wrap() {
        return new LatLng(this.latitude, LatLng.wrap(this.longitude, -180.0, 180.0));
    }

    static double wrap(double value, double min, double max) {
        double delta = max - min;
        double firstMod = (value - min) % delta;
        double secondMod = (firstMod + delta) % delta;
        if (value >= max && secondMod == 0.0) {
            return max;
        }
        return secondMod + min;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LatLng latLng = (LatLng)object;
        return Double.compare(latLng.altitude, this.altitude) == 0 && Double.compare(latLng.latitude, this.latitude) == 0 && Double.compare(latLng.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @NonNull
    public String toString() {
        return "LatLng [latitude=" + this.latitude + ", longitude=" + this.longitude + ", altitude=" + this.altitude + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeDouble(this.latitude);
        out.writeDouble(this.longitude);
        out.writeDouble(this.altitude);
    }

    public double distanceTo(@NonNull LatLng other) {
        return TurfMeasurement.distance((Point)Point.fromLngLat((double)this.longitude, (double)this.latitude), (Point)Point.fromLngLat((double)other.getLongitude(), (double)other.getLatitude()), (String)"metres");
    }
}

