/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.turf.TurfMeasurement;

public class OfflineGeometryRegionDefinition
implements OfflineRegionDefinition {
    @Keep
    private String styleURL;
    @Nullable
    @Keep
    private Geometry geometry;
    @Keep
    private double minZoom;
    @Keep
    private double maxZoom;
    @Keep
    private float pixelRatio;
    @Keep
    private boolean includeIdeographs;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public OfflineGeometryRegionDefinition createFromParcel(@NonNull Parcel in) {
            return new OfflineGeometryRegionDefinition(in);
        }

        public OfflineGeometryRegionDefinition[] newArray(int size) {
            return new OfflineGeometryRegionDefinition[size];
        }
    };

    @Keep
    public OfflineGeometryRegionDefinition(String styleURL, Geometry geometry, double minZoom, double maxZoom, float pixelRatio) {
        this(styleURL, geometry, minZoom, maxZoom, pixelRatio, false);
    }

    @Keep
    public OfflineGeometryRegionDefinition(String styleURL, Geometry geometry, double minZoom, double maxZoom, float pixelRatio, boolean includeIdeographs) {
        this.styleURL = styleURL;
        this.geometry = geometry;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.pixelRatio = pixelRatio;
        this.includeIdeographs = includeIdeographs;
    }

    public OfflineGeometryRegionDefinition(Parcel parcel) {
        this.styleURL = parcel.readString();
        this.geometry = Feature.fromJson((String)parcel.readString()).geometry();
        this.minZoom = parcel.readDouble();
        this.maxZoom = parcel.readDouble();
        this.pixelRatio = parcel.readFloat();
        this.includeIdeographs = parcel.readByte() != 0;
    }

    @Override
    public String getStyleURL() {
        return this.styleURL;
    }

    @Nullable
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    @Nullable
    public LatLngBounds getBounds() {
        if (this.geometry == null) {
            return null;
        }
        double[] bbox = TurfMeasurement.bbox((Geometry)this.geometry);
        return LatLngBounds.from(bbox[3], bbox[2], bbox[1], bbox[0]);
    }

    @Override
    public double getMinZoom() {
        return this.minZoom;
    }

    @Override
    public double getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public float getPixelRatio() {
        return this.pixelRatio;
    }

    @Override
    public boolean getIncludeIdeographs() {
        return this.includeIdeographs;
    }

    @Override
    @NonNull
    public String getType() {
        return "shaperegion";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.styleURL);
        dest.writeString(Feature.fromGeometry((Geometry)this.geometry).toJson());
        dest.writeDouble(this.minZoom);
        dest.writeDouble(this.maxZoom);
        dest.writeFloat(this.pixelRatio);
        dest.writeByte((byte)(this.includeIdeographs ? 1 : 0));
    }
}

