/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
class LocationIndicatorLayer
extends Layer {
    @Keep
    LocationIndicatorLayer(long nativePtr) {
        super(nativePtr);
    }

    public LocationIndicatorLayer(String layerId) {
        this.initialize(layerId);
    }

    @Keep
    protected native void initialize(String var1);

    @NonNull
    public LocationIndicatorLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<String> getTopImage() {
        this.checkThread();
        return new PropertyValue<Object>("top-image", this.nativeGetTopImage());
    }

    @NonNull
    public PropertyValue<String> getBearingImage() {
        this.checkThread();
        return new PropertyValue<Object>("bearing-image", this.nativeGetBearingImage());
    }

    @NonNull
    public PropertyValue<String> getShadowImage() {
        this.checkThread();
        return new PropertyValue<Object>("shadow-image", this.nativeGetShadowImage());
    }

    @NonNull
    public PropertyValue<Float> getPerspectiveCompensation() {
        this.checkThread();
        return new PropertyValue<Object>("perspective-compensation", this.nativeGetPerspectiveCompensation());
    }

    @NonNull
    public PropertyValue<Float> getImageTiltDisplacement() {
        this.checkThread();
        return new PropertyValue<Object>("image-tilt-displacement", this.nativeGetImageTiltDisplacement());
    }

    @NonNull
    public PropertyValue<Double> getBearing() {
        this.checkThread();
        return new PropertyValue<Object>("bearing", this.nativeGetBearing());
    }

    @NonNull
    public PropertyValue<Double[]> getLocation() {
        this.checkThread();
        return new PropertyValue<Object>("location", this.nativeGetLocation());
    }

    @NonNull
    public TransitionOptions getLocationTransition() {
        this.checkThread();
        return this.nativeGetLocationTransition();
    }

    public void setLocationTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLocationTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getAccuracyRadius() {
        this.checkThread();
        return new PropertyValue<Object>("accuracy-radius", this.nativeGetAccuracyRadius());
    }

    @NonNull
    public TransitionOptions getAccuracyRadiusTransition() {
        this.checkThread();
        return this.nativeGetAccuracyRadiusTransition();
    }

    public void setAccuracyRadiusTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetAccuracyRadiusTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getTopImageSize() {
        this.checkThread();
        return new PropertyValue<Object>("top-image-size", this.nativeGetTopImageSize());
    }

    @NonNull
    public TransitionOptions getTopImageSizeTransition() {
        this.checkThread();
        return this.nativeGetTopImageSizeTransition();
    }

    public void setTopImageSizeTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetTopImageSizeTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getBearingImageSize() {
        this.checkThread();
        return new PropertyValue<Object>("bearing-image-size", this.nativeGetBearingImageSize());
    }

    @NonNull
    public TransitionOptions getBearingImageSizeTransition() {
        this.checkThread();
        return this.nativeGetBearingImageSizeTransition();
    }

    public void setBearingImageSizeTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetBearingImageSizeTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getShadowImageSize() {
        this.checkThread();
        return new PropertyValue<Object>("shadow-image-size", this.nativeGetShadowImageSize());
    }

    @NonNull
    public TransitionOptions getShadowImageSizeTransition() {
        this.checkThread();
        return this.nativeGetShadowImageSizeTransition();
    }

    public void setShadowImageSizeTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetShadowImageSizeTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getAccuracyRadiusColor() {
        this.checkThread();
        return new PropertyValue<Object>("accuracy-radius-color", this.nativeGetAccuracyRadiusColor());
    }

    @ColorInt
    public int getAccuracyRadiusColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getAccuracyRadiusColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("accuracy-radius-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getAccuracyRadiusColorTransition() {
        this.checkThread();
        return this.nativeGetAccuracyRadiusColorTransition();
    }

    public void setAccuracyRadiusColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetAccuracyRadiusColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getAccuracyRadiusBorderColor() {
        this.checkThread();
        return new PropertyValue<Object>("accuracy-radius-border-color", this.nativeGetAccuracyRadiusBorderColor());
    }

    @ColorInt
    public int getAccuracyRadiusBorderColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getAccuracyRadiusBorderColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("accuracy-radius-border-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getAccuracyRadiusBorderColorTransition() {
        this.checkThread();
        return this.nativeGetAccuracyRadiusBorderColorTransition();
    }

    public void setAccuracyRadiusBorderColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetAccuracyRadiusBorderColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    @Keep
    private native Object nativeGetTopImage();

    @NonNull
    @Keep
    private native Object nativeGetBearingImage();

    @NonNull
    @Keep
    private native Object nativeGetShadowImage();

    @NonNull
    @Keep
    private native Object nativeGetPerspectiveCompensation();

    @NonNull
    @Keep
    private native Object nativeGetImageTiltDisplacement();

    @NonNull
    @Keep
    private native Object nativeGetBearing();

    @NonNull
    @Keep
    private native Object nativeGetLocation();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLocationTransition();

    @Keep
    private native void nativeSetLocationTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetAccuracyRadius();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetAccuracyRadiusTransition();

    @Keep
    private native void nativeSetAccuracyRadiusTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetTopImageSize();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetTopImageSizeTransition();

    @Keep
    private native void nativeSetTopImageSizeTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetBearingImageSize();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetBearingImageSizeTransition();

    @Keep
    private native void nativeSetBearingImageSizeTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetShadowImageSize();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetShadowImageSizeTransition();

    @Keep
    private native void nativeSetShadowImageSizeTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetAccuracyRadiusColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetAccuracyRadiusColorTransition();

    @Keep
    private native void nativeSetAccuracyRadiusColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetAccuracyRadiusBorderColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetAccuracyRadiusBorderColorTransition();

    @Keep
    private native void nativeSetAccuracyRadiusBorderColorTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

