/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.style.sources.TileSet;
import java.net.URI;
import java.net.URL;

public class RasterSource
extends Source {
    public static final int DEFAULT_TILE_SIZE = 512;

    @Keep
    RasterSource(long nativePtr) {
        super(nativePtr);
    }

    public RasterSource(String id2, URL url) {
        this(id2, url.toExternalForm());
    }

    public RasterSource(String id2, URI uri) {
        this(id2, uri.toString());
    }

    public RasterSource(String id2, String uri) {
        this.initialize(id2, uri, 512);
    }

    public RasterSource(String id2, String uri, int tileSize) {
        this.initialize(id2, uri, tileSize);
    }

    public RasterSource(String id2, TileSet tileSet) {
        this.initialize(id2, tileSet.toValueObject(), 512);
    }

    public RasterSource(String id2, TileSet tileSet, int tileSize) {
        this.initialize(id2, tileSet.toValueObject(), tileSize);
    }

    @Deprecated
    @Nullable
    public String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @Nullable
    public String getUri() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @Keep
    protected native void initialize(String var1, Object var2, int var3);

    @Keep
    protected native void finalize() throws Throwable;

    @NonNull
    @Keep
    protected native String nativeGetUrl();
}

