/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import androidx.annotation.NonNull;
import androidx.annotation.Size;

abstract class MapboxAnimator<K>
extends ValueAnimator
implements ValueAnimator.AnimatorUpdateListener {
    static final int ANIMATOR_LAYER_LATLNG = 0;
    static final int ANIMATOR_CAMERA_LATLNG = 1;
    static final int ANIMATOR_LAYER_GPS_BEARING = 2;
    static final int ANIMATOR_LAYER_COMPASS_BEARING = 3;
    static final int ANIMATOR_CAMERA_GPS_BEARING = 4;
    static final int ANIMATOR_CAMERA_COMPASS_BEARING = 5;
    static final int ANIMATOR_LAYER_ACCURACY = 6;
    static final int ANIMATOR_ZOOM = 7;
    static final int ANIMATOR_TILT = 8;
    private final AnimationsValueChangeListener<K> updateListener;
    private final K target;
    private K animatedValue;
    private final double minUpdateInterval;
    private long timeElapsed;
    private boolean invalid;

    MapboxAnimator(@NonNull @Size(min=2L) K[] values, @NonNull AnimationsValueChangeListener<K> updateListener, int maxAnimationFps) {
        this.minUpdateInterval = 1.0E9 / (double)maxAnimationFps;
        this.setObjectValues(values);
        this.setEvaluator(this.provideEvaluator());
        this.updateListener = updateListener;
        this.target = values[values.length - 1];
        this.addUpdateListener(this);
        this.addListener((Animator.AnimatorListener)new AnimatorListener());
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.animatedValue = animation.getAnimatedValue();
        long currentTime = System.nanoTime();
        if ((double)(currentTime - this.timeElapsed) < this.minUpdateInterval) {
            return;
        }
        this.postUpdates();
        this.timeElapsed = currentTime;
    }

    private void postUpdates() {
        if (!this.invalid) {
            this.updateListener.onNewAnimationValue(this.animatedValue);
        }
    }

    K getTarget() {
        return this.target;
    }

    abstract TypeEvaluator provideEvaluator();

    public void makeInvalid() {
        this.invalid = true;
    }

    static interface AnimationsValueChangeListener<K> {
        public void onNewAnimationValue(K var1);
    }

    private class AnimatorListener
    extends AnimatorListenerAdapter {
        private AnimatorListener() {
        }

        public void onAnimationEnd(Animator animation) {
            MapboxAnimator.this.postUpdates();
        }
    }
}

