/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.maps.Style;

public class LocationComponentActivationOptions {
    private final Context context;
    private final Style style;
    private final LocationEngine locationEngine;
    private final LocationEngineRequest locationEngineRequest;
    private final LocationComponentOptions locationComponentOptions;
    private final int styleRes;
    private final boolean useDefaultLocationEngine;
    private final boolean useSpecializedLocationLayer;

    private LocationComponentActivationOptions(@NonNull Context context, @NonNull Style style2, @Nullable LocationEngine locationEngine, @Nullable LocationEngineRequest locationEngineRequest, @Nullable LocationComponentOptions locationComponentOptions, int styleRes, boolean useDefaultLocationEngine, boolean useSpecializedLocationLayer) {
        this.context = context;
        this.style = style2;
        this.locationEngine = locationEngine;
        this.locationEngineRequest = locationEngineRequest;
        this.locationComponentOptions = locationComponentOptions;
        this.styleRes = styleRes;
        this.useDefaultLocationEngine = useDefaultLocationEngine;
        this.useSpecializedLocationLayer = useSpecializedLocationLayer;
    }

    @NonNull
    public static Builder builder(@NonNull Context context, @NonNull Style fullyLoadedMapStyle) {
        return new Builder(context, fullyLoadedMapStyle);
    }

    @NonNull
    public Context context() {
        return this.context;
    }

    @NonNull
    public Style style() {
        return this.style;
    }

    @Nullable
    public LocationEngine locationEngine() {
        return this.locationEngine;
    }

    @Nullable
    public LocationEngineRequest locationEngineRequest() {
        return this.locationEngineRequest;
    }

    @Nullable
    public LocationComponentOptions locationComponentOptions() {
        return this.locationComponentOptions;
    }

    public int styleRes() {
        return this.styleRes;
    }

    public boolean useDefaultLocationEngine() {
        return this.useDefaultLocationEngine;
    }

    public boolean useSpecializedLocationLayer() {
        return this.useSpecializedLocationLayer;
    }

    public static class Builder {
        private final Context context;
        private final Style style;
        private LocationEngine locationEngine;
        private LocationEngineRequest locationEngineRequest;
        private LocationComponentOptions locationComponentOptions;
        private int styleRes;
        private boolean useDefaultLocationEngine = true;
        private boolean useSpecializedLocationLayer = false;

        public Builder(@NonNull Context context, @NonNull Style style2) {
            this.context = context;
            this.style = style2;
        }

        @NonNull
        public Builder locationEngine(@Nullable LocationEngine locationEngine) {
            this.locationEngine = locationEngine;
            return this;
        }

        public Builder locationEngineRequest(LocationEngineRequest locationEngineRequest) {
            this.locationEngineRequest = locationEngineRequest;
            return this;
        }

        public Builder locationComponentOptions(LocationComponentOptions locationComponentOptions) {
            this.locationComponentOptions = locationComponentOptions;
            return this;
        }

        public Builder styleRes(int styleRes) {
            this.styleRes = styleRes;
            return this;
        }

        public Builder useDefaultLocationEngine(boolean useDefaultLocationEngine) {
            this.useDefaultLocationEngine = useDefaultLocationEngine;
            return this;
        }

        public Builder useSpecializedLocationLayer(boolean useSpecializedLocationLayer) {
            this.useSpecializedLocationLayer = useSpecializedLocationLayer;
            return this;
        }

        public LocationComponentActivationOptions build() {
            if (this.styleRes != 0 && this.locationComponentOptions != null) {
                throw new IllegalArgumentException("You've provided both a style resource and a LocationComponentOptions object to the LocationComponentActivationOptions builder. You can't use both and you must choose one of the two to style the LocationComponent.");
            }
            if (this.context == null) {
                throw new NullPointerException("Context in LocationComponentActivationOptions is null.");
            }
            if (this.style == null) {
                throw new NullPointerException("Style in LocationComponentActivationOptions is null. Make sure the Style object isn't null. Wait for the map to fully load before passing the Style object to LocationComponentActivationOptions.");
            }
            if (!this.style.isFullyLoaded()) {
                throw new IllegalArgumentException("Style in LocationComponentActivationOptions isn't fully loaded. Wait for the map to fully load before passing the Style object to LocationComponentActivationOptions.");
            }
            return new LocationComponentActivationOptions(this.context, this.style, this.locationEngine, this.locationEngineRequest, this.locationComponentOptions, this.styleRes, this.useDefaultLocationEngine, this.useSpecializedLocationLayer);
        }
    }
}

