/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.os.Bundle;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.mapbox.android.telemetry.TelemetryUtils;
import com.mapbox.mapboxsdk.module.telemetry.MapLoadEvent;
import com.mapbox.mapboxsdk.module.telemetry.OfflineDownloadEndEvent;
import com.mapbox.mapboxsdk.module.telemetry.OfflineDownloadStartEvent;
import com.mapbox.mapboxsdk.module.telemetry.PerformanceEvent;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;

class MapEventFactory {
    MapEventFactory() {
    }

    static MapLoadEvent buildMapLoadEvent(@NonNull PhoneState phoneState) {
        String userId = TelemetryUtils.retrieveVendorId();
        return new MapLoadEvent(userId, phoneState);
    }

    static OfflineDownloadStartEvent buildOfflineDownloadStartEvent(PhoneState phoneState, String shapeForOfflineRegion, @FloatRange(from=0.0, to=25.5) Double minZoom, @FloatRange(from=0.0, to=25.5) Double maxZoom, String styleURL) {
        OfflineDownloadStartEvent offlineEvent = new OfflineDownloadStartEvent(phoneState, shapeForOfflineRegion, minZoom, maxZoom);
        offlineEvent.setStyleURL(styleURL);
        return offlineEvent;
    }

    static OfflineDownloadEndEvent buildOfflineDownloadCompleteEvent(PhoneState phoneState, String shapeForOfflineRegion, @FloatRange(from=0.0, to=25.5) Double minZoom, @FloatRange(from=0.0, to=25.5) Double maxZoom, String styleURL, long sizeOfResourcesCompleted, long numberOfTilesCompleted, int state) {
        OfflineDownloadEndEvent offlineEvent = new OfflineDownloadEndEvent(phoneState, shapeForOfflineRegion, minZoom, maxZoom);
        offlineEvent.setStyleURL(styleURL);
        offlineEvent.setSizeOfResourcesCompleted(sizeOfResourcesCompleted);
        offlineEvent.setNumberOfTilesCompleted(numberOfTilesCompleted);
        offlineEvent.setState(state);
        return offlineEvent;
    }

    static PerformanceEvent buildPerformanceEvent(@NonNull PhoneState phoneState, @NonNull String sessionId, @NonNull Bundle data) {
        return new PerformanceEvent(phoneState, sessionId, data);
    }
}

