/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.geometry.LatLngQuad;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.net.URI;
import java.net.URL;

@UiThread
public class ImageSource
extends Source {
    @Keep
    ImageSource(long nativePtr) {
        super(nativePtr);
    }

    @Deprecated
    public ImageSource(String id2, LatLngQuad coordinates, @NonNull URL url) {
        this.initialize(id2, coordinates);
        this.setUrl(url);
    }

    public ImageSource(String id2, LatLngQuad coordinates, @NonNull URI uri) {
        this.initialize(id2, coordinates);
        this.setUri(uri);
    }

    public ImageSource(String id2, LatLngQuad coordinates, @NonNull Bitmap bitmap) {
        this.initialize(id2, coordinates);
        this.setImage(bitmap);
    }

    public ImageSource(String id2, LatLngQuad coordinates, @DrawableRes int resourceId) {
        this.initialize(id2, coordinates);
        this.setImage(resourceId);
    }

    @Deprecated
    public void setUrl(@NonNull URL url) {
        this.setUrl(url.toExternalForm());
    }

    @Deprecated
    public void setUrl(String url) {
        this.checkThread();
        this.nativeSetUrl(url);
    }

    public void setUri(@NonNull URI uri) {
        this.checkThread();
        this.nativeSetUrl(uri.toString());
    }

    public void setUri(String uri) {
        this.checkThread();
        this.nativeSetUrl(uri);
    }

    public void setImage(@NonNull Bitmap bitmap) {
        this.checkThread();
        this.nativeSetImage(bitmap);
    }

    public void setImage(@DrawableRes int resourceId) throws IllegalArgumentException {
        this.checkThread();
        Context context = Mapbox.getApplicationContext();
        Drawable drawable2 = BitmapUtils.getDrawableFromRes(context, resourceId);
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalArgumentException("Failed to decode image. The resource provided must be a Bitmap.");
        }
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        this.nativeSetImage(bitmapDrawable.getBitmap());
    }

    @Deprecated
    @Nullable
    public String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @Nullable
    public String getUri() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    public void setCoordinates(LatLngQuad latLngQuad) {
        this.checkThread();
        this.nativeSetCoordinates(latLngQuad);
    }

    @Keep
    protected native void initialize(String var1, LatLngQuad var2);

    @Keep
    protected native void nativeSetUrl(String var1);

    @NonNull
    @Keep
    protected native String nativeGetUrl();

    @Keep
    protected native void nativeSetImage(Bitmap var1);

    @Keep
    protected native void nativeSetCoordinates(LatLngQuad var1);

    @Keep
    protected native void finalize() throws Throwable;
}

