/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import androidx.annotation.NonNull;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import java.util.HashMap;

public class GeoJsonOptions
extends HashMap<String, Object> {
    @NonNull
    public GeoJsonOptions withMinZoom(int minZoom) {
        this.put("minzoom", minZoom);
        return this;
    }

    @NonNull
    public GeoJsonOptions withMaxZoom(int maxZoom) {
        this.put("maxzoom", maxZoom);
        return this;
    }

    @NonNull
    public GeoJsonOptions withBuffer(int buffer) {
        this.put("buffer", buffer);
        return this;
    }

    @NonNull
    public GeoJsonOptions withLineMetrics(boolean lineMetrics) {
        this.put("lineMetrics", lineMetrics);
        return this;
    }

    @NonNull
    public GeoJsonOptions withTolerance(float tolerance) {
        this.put("tolerance", Float.valueOf(tolerance));
        return this;
    }

    @NonNull
    public GeoJsonOptions withCluster(boolean cluster) {
        this.put("cluster", cluster);
        return this;
    }

    @NonNull
    public GeoJsonOptions withClusterMaxZoom(int clusterMaxZoom) {
        this.put("clusterMaxZoom", clusterMaxZoom);
        return this;
    }

    @NonNull
    public GeoJsonOptions withClusterRadius(int clusterRadius) {
        this.put("clusterRadius", clusterRadius);
        return this;
    }

    @NonNull
    public GeoJsonOptions withClusterProperty(String propertyName, Expression operatorExpr, Expression mapExpr) {
        HashMap properties = this.containsKey("clusterProperties") ? (HashMap)this.get("clusterProperties") : new HashMap();
        Object operator = operatorExpr instanceof Expression.ExpressionLiteral ? ((Expression.ExpressionLiteral)operatorExpr).toValue() : operatorExpr.toArray();
        Object[] map = mapExpr.toArray();
        properties.put(propertyName, new Object[]{operator, map});
        this.put("clusterProperties", properties);
        return this;
    }
}

