/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;

public abstract class LibraryLoader {
    private static final String TAG = "Mbgl-LibraryLoader";
    private static final LibraryLoader DEFAULT;
    private static volatile LibraryLoader loader;
    private static boolean loaded;

    public static void setLibraryLoader(LibraryLoader libraryLoader) {
        loader = libraryLoader;
    }

    public static void load() {
        try {
            if (!loaded) {
                loaded = true;
                loader.load("mapbox-gl");
            }
        }
        catch (UnsatisfiedLinkError error) {
            loaded = false;
            String message = "Failed to load native shared library.";
            Logger.e(TAG, message, error);
            MapStrictMode.strictModeViolation(message, error);
        }
    }

    public abstract void load(String var1);

    static {
        loader = DEFAULT = Mapbox.getModuleProvider().createLibraryLoaderProvider().getDefaultLibraryLoader();
    }
}

