/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.attribution.Attribution;
import com.mapbox.mapboxsdk.attribution.AttributionParser;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttributionDialogManager
implements View.OnClickListener,
DialogInterface.OnClickListener {
    private static final String MAP_FEEDBACK_URL = "https://apps.mapbox.com/feedback";
    private static final String MAP_FEEDBACK_URL_OLD = "https://www.mapbox.com/map-feedback";
    private static final String MAP_FEEDBACK_URL_LOCATION_FRAGMENT_FORMAT = "/%f/%f/%f/%f/%d";
    private static final String MAP_FEEDBACK_STYLE_URI_REGEX = "^(.*://[^:^/]*)/(.*)/(.*)";
    @NonNull
    private final Context context;
    @NonNull
    private final MapboxMap mapboxMap;
    private Set<Attribution> attributionSet;
    private AlertDialog dialog;

    public AttributionDialogManager(@NonNull Context context, @NonNull MapboxMap mapboxMap) {
        this.context = context;
        this.mapboxMap = mapboxMap;
    }

    public void onClick(@NonNull View view) {
        this.attributionSet = new AttributionBuilder(this.mapboxMap, view.getContext()).build();
        boolean isActivityFinishing = false;
        if (this.context instanceof Activity) {
            isActivityFinishing = ((Activity)this.context).isFinishing();
        }
        if (!isActivityFinishing) {
            this.showAttributionDialog(this.getAttributionTitles());
        }
    }

    protected void showAttributionDialog(@NonNull String[] attributionTitles) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(R.string.mapbox_attributionsDialogTitle);
        builder.setAdapter((ListAdapter)new ArrayAdapter(this.context, R.layout.mapbox_attribution_list_item, (Object[])attributionTitles), (DialogInterface.OnClickListener)this);
        this.dialog = builder.show();
    }

    private String[] getAttributionTitles() {
        ArrayList<String> titles = new ArrayList<String>();
        for (Attribution attribution : this.attributionSet) {
            titles.add(attribution.getTitle());
        }
        return titles.toArray(new String[titles.size()]);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.isLatestEntry(which)) {
            this.showTelemetryDialog();
        } else {
            this.showMapAttributionWebPage(which);
        }
    }

    public void onStop() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    private boolean isLatestEntry(int attributionKeyIndex) {
        return attributionKeyIndex == this.getAttributionTitles().length - 1;
    }

    private void showTelemetryDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(R.string.mapbox_attributionTelemetryTitle);
        builder.setMessage(R.string.mapbox_attributionTelemetryMessage);
        builder.setPositiveButton(R.string.mapbox_attributionTelemetryPositive, new DialogInterface.OnClickListener(){

            public void onClick(@NonNull DialogInterface dialog, int which) {
                TelemetryDefinition telemetry = Mapbox.getTelemetry();
                if (telemetry != null) {
                    telemetry.setUserTelemetryRequestState(true);
                }
                dialog.cancel();
            }
        });
        builder.setNeutralButton(R.string.mapbox_attributionTelemetryNeutral, new DialogInterface.OnClickListener(){

            public void onClick(@NonNull DialogInterface dialog, int which) {
                AttributionDialogManager.this.showWebPage(AttributionDialogManager.this.context.getResources().getString(R.string.mapbox_telemetryLink));
                dialog.cancel();
            }
        });
        builder.setNegativeButton(R.string.mapbox_attributionTelemetryNegative, new DialogInterface.OnClickListener(){

            public void onClick(@NonNull DialogInterface dialog, int which) {
                TelemetryDefinition telemetry = Mapbox.getTelemetry();
                if (telemetry != null) {
                    telemetry.setUserTelemetryRequestState(false);
                }
                dialog.cancel();
            }
        });
        builder.show();
    }

    private void showMapAttributionWebPage(int which) {
        Attribution[] attributions = this.attributionSet.toArray(new Attribution[this.attributionSet.size()]);
        String url = attributions[which].getUrl();
        if (url.contains(MAP_FEEDBACK_URL_OLD) || url.contains(MAP_FEEDBACK_URL)) {
            url = this.buildMapFeedbackMapUrl(Mapbox.getAccessToken());
        }
        this.showWebPage(url);
    }

    @NonNull
    String buildMapFeedbackMapUrl(@Nullable String accessToken) {
        Style style2;
        String packageName;
        Uri.Builder builder = Uri.parse((String)MAP_FEEDBACK_URL).buildUpon();
        CameraPosition cameraPosition = this.mapboxMap.getCameraPosition();
        if (cameraPosition != null) {
            builder.encodedFragment(String.format(Locale.getDefault(), MAP_FEEDBACK_URL_LOCATION_FRAGMENT_FORMAT, cameraPosition.target.getLongitude(), cameraPosition.target.getLatitude(), cameraPosition.zoom, cameraPosition.bearing, (int)cameraPosition.tilt));
        }
        if ((packageName = this.context.getApplicationContext().getPackageName()) != null) {
            builder.appendQueryParameter("referrer", packageName);
        }
        if (accessToken != null) {
            builder.appendQueryParameter("access_token", accessToken);
        }
        if ((style2 = this.mapboxMap.getStyle()) != null) {
            String styleUri = style2.getUri();
            Pattern pattern = Pattern.compile(MAP_FEEDBACK_STYLE_URI_REGEX);
            Matcher matcher = pattern.matcher(styleUri);
            if (matcher.find()) {
                String styleOwner = matcher.group(2);
                String styleId = matcher.group(3);
                builder.appendQueryParameter("owner", styleOwner).appendQueryParameter("id", styleId);
            }
        }
        return builder.build().toString();
    }

    private void showWebPage(@NonNull String url) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.context.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            Toast.makeText((Context)this.context, (int)R.string.mapbox_attributionErrorNoBrowser, (int)1).show();
            MapStrictMode.strictModeViolation(exception);
        }
    }

    private static class AttributionBuilder {
        private final MapboxMap mapboxMap;
        @NonNull
        private final WeakReference<Context> context;

        AttributionBuilder(MapboxMap mapboxMap, Context context) {
            this.mapboxMap = mapboxMap;
            this.context = new WeakReference<Context>(context);
        }

        private Set<Attribution> build() {
            Context context = (Context)this.context.get();
            if (context == null) {
                return Collections.emptySet();
            }
            ArrayList<String> attributions = new ArrayList<String>();
            Style style2 = this.mapboxMap.getStyle();
            if (style2 != null) {
                for (Source source : style2.getSources()) {
                    String attribution = source.getAttribution();
                    if (attribution.isEmpty()) continue;
                    attributions.add(attribution);
                }
            }
            return new AttributionParser.Options(context).withCopyrightSign(true).withImproveMap(true).withTelemetryAttribution(true).withAttributionData(attributions.toArray(new String[attributions.size()])).build().getAttributions();
        }
    }
}

