/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.annotation.SuppressLint;
import android.support.annotation.FloatRange;
import com.mapbox.mapboxsdk.module.telemetry.MapBaseEvent;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;

@SuppressLint(value={"ParcelCreator"})
public class OfflineDownloadStartEvent
extends MapBaseEvent {
    private static final String EVENT_NAME = "map.offlineDownload.start";
    private final Double minZoom;
    private final Double maxZoom;
    private final String shapeForOfflineRegion;
    private String styleURL;

    OfflineDownloadStartEvent(PhoneState phoneState, String shapeForOfflineRegion, @FloatRange(from=0.0, to=25.5) Double minZoom, @FloatRange(from=0.0, to=25.5) Double maxZoom) {
        super(phoneState);
        this.shapeForOfflineRegion = shapeForOfflineRegion;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
    }

    @Override
    String getEventName() {
        return EVENT_NAME;
    }

    Double getMinZoom() {
        return this.minZoom;
    }

    Double getMaxZoom() {
        return this.maxZoom;
    }

    String getShapeForOfflineRegion() {
        return this.shapeForOfflineRegion;
    }

    String getStyleURL() {
        return this.styleURL;
    }

    void setStyleURL(String styleURL) {
        this.styleURL = styleURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OfflineDownloadStartEvent that = (OfflineDownloadStartEvent)((Object)o);
        if (this.minZoom != null ? !this.minZoom.equals(that.minZoom) : that.minZoom != null) {
            return false;
        }
        if (this.maxZoom != null ? !this.maxZoom.equals(that.maxZoom) : that.maxZoom != null) {
            return false;
        }
        if (this.shapeForOfflineRegion != null ? !this.shapeForOfflineRegion.equals(that.shapeForOfflineRegion) : that.shapeForOfflineRegion != null) {
            return false;
        }
        return this.styleURL != null ? this.styleURL.equals(that.styleURL) : that.styleURL == null;
    }

    public int hashCode() {
        int result = this.minZoom != null ? this.minZoom.hashCode() : 0;
        result = 31 * result + (this.maxZoom != null ? this.maxZoom.hashCode() : 0);
        result = 31 * result + (this.shapeForOfflineRegion != null ? this.shapeForOfflineRegion.hashCode() : 0);
        result = 31 * result + (this.styleURL != null ? this.styleURL.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OfflineDownloadStartEvent{, minZoom=" + this.minZoom + ", maxZoom=" + this.maxZoom + ", shapeForOfflineRegion='" + this.shapeForOfflineRegion + '\'' + ", styleURL='" + this.styleURL + '\'' + '}';
    }
}

